/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.CatalogObjectBatch;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class BatchUpsertCatalogObjectsRequest {
    private final String idempotencyKey;
    private final List<CatalogObjectBatch> batches;
    private final Map<String, Object> additionalProperties;

    private BatchUpsertCatalogObjectsRequest(String idempotencyKey, List<CatalogObjectBatch> batches, Map<String, Object> additionalProperties) {
        this.idempotencyKey = idempotencyKey;
        this.batches = batches;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="idempotency_key")
    public String getIdempotencyKey() {
        return this.idempotencyKey;
    }

    @JsonProperty(value="batches")
    public List<CatalogObjectBatch> getBatches() {
        return this.batches;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof BatchUpsertCatalogObjectsRequest && this.equalTo((BatchUpsertCatalogObjectsRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(BatchUpsertCatalogObjectsRequest other) {
        return this.idempotencyKey.equals(other.idempotencyKey) && this.batches.equals(other.batches);
    }

    public int hashCode() {
        return Objects.hash(this.idempotencyKey, this.batches);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdempotencyKeyStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdempotencyKeyStage,
    _FinalStage {
        private String idempotencyKey;
        private List<CatalogObjectBatch> batches = new ArrayList<CatalogObjectBatch>();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(BatchUpsertCatalogObjectsRequest other) {
            this.idempotencyKey(other.getIdempotencyKey());
            this.batches(other.getBatches());
            return this;
        }

        @Override
        @JsonSetter(value="idempotency_key")
        public _FinalStage idempotencyKey(@NotNull String idempotencyKey) {
            this.idempotencyKey = Objects.requireNonNull(idempotencyKey, "idempotencyKey must not be null");
            return this;
        }

        @Override
        public _FinalStage addAllBatches(List<CatalogObjectBatch> batches) {
            this.batches.addAll(batches);
            return this;
        }

        @Override
        public _FinalStage addBatches(CatalogObjectBatch batches) {
            this.batches.add(batches);
            return this;
        }

        @Override
        @JsonSetter(value="batches", nulls=Nulls.SKIP)
        public _FinalStage batches(List<CatalogObjectBatch> batches) {
            this.batches.clear();
            this.batches.addAll(batches);
            return this;
        }

        @Override
        public BatchUpsertCatalogObjectsRequest build() {
            return new BatchUpsertCatalogObjectsRequest(this.idempotencyKey, this.batches, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public BatchUpsertCatalogObjectsRequest build();

        public _FinalStage batches(List<CatalogObjectBatch> var1);

        public _FinalStage addBatches(CatalogObjectBatch var1);

        public _FinalStage addAllBatches(List<CatalogObjectBatch> var1);
    }

    public static interface IdempotencyKeyStage {
        public _FinalStage idempotencyKey(@NotNull String var1);

        public Builder from(BatchUpsertCatalogObjectsRequest var1);
    }
}

