/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class BatchGetVendorsRequest {
    private final Optional<List<String>> vendorIds;
    private final Map<String, Object> additionalProperties;

    private BatchGetVendorsRequest(Optional<List<String>> vendorIds, Map<String, Object> additionalProperties) {
        this.vendorIds = vendorIds;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<List<String>> getVendorIds() {
        if (this.vendorIds == null) {
            return Optional.empty();
        }
        return this.vendorIds;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="vendor_ids")
    private Optional<List<String>> _getVendorIds() {
        return this.vendorIds;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof BatchGetVendorsRequest && this.equalTo((BatchGetVendorsRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(BatchGetVendorsRequest other) {
        return this.vendorIds.equals(other.vendorIds);
    }

    public int hashCode() {
        return Objects.hash(this.vendorIds);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<List<String>> vendorIds = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(BatchGetVendorsRequest other) {
            this.vendorIds(other.getVendorIds());
            return this;
        }

        @JsonSetter(value="vendor_ids", nulls=Nulls.SKIP)
        public Builder vendorIds(Optional<List<String>> vendorIds) {
            this.vendorIds = vendorIds;
            return this;
        }

        public Builder vendorIds(List<String> vendorIds) {
            this.vendorIds = Optional.ofNullable(vendorIds);
            return this;
        }

        public Builder vendorIds(Nullable<List<String>> vendorIds) {
            this.vendorIds = vendorIds.isNull() ? null : (vendorIds.isEmpty() ? Optional.empty() : Optional.of(vendorIds.get()));
            return this;
        }

        public BatchGetVendorsRequest build() {
            return new BatchGetVendorsRequest(this.vendorIds, this.additionalProperties);
        }
    }
}

