/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class BatchGetOrdersRequest {
    private final Optional<String> locationId;
    private final List<String> orderIds;
    private final Map<String, Object> additionalProperties;

    private BatchGetOrdersRequest(Optional<String> locationId, List<String> orderIds, Map<String, Object> additionalProperties) {
        this.locationId = locationId;
        this.orderIds = orderIds;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<String> getLocationId() {
        if (this.locationId == null) {
            return Optional.empty();
        }
        return this.locationId;
    }

    @JsonProperty(value="order_ids")
    public List<String> getOrderIds() {
        return this.orderIds;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="location_id")
    private Optional<String> _getLocationId() {
        return this.locationId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof BatchGetOrdersRequest && this.equalTo((BatchGetOrdersRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(BatchGetOrdersRequest other) {
        return this.locationId.equals(other.locationId) && this.orderIds.equals(other.orderIds);
    }

    public int hashCode() {
        return Objects.hash(this.locationId, this.orderIds);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> locationId = Optional.empty();
        private List<String> orderIds = new ArrayList<String>();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(BatchGetOrdersRequest other) {
            this.locationId(other.getLocationId());
            this.orderIds(other.getOrderIds());
            return this;
        }

        @JsonSetter(value="location_id", nulls=Nulls.SKIP)
        public Builder locationId(Optional<String> locationId) {
            this.locationId = locationId;
            return this;
        }

        public Builder locationId(String locationId) {
            this.locationId = Optional.ofNullable(locationId);
            return this;
        }

        public Builder locationId(Nullable<String> locationId) {
            this.locationId = locationId.isNull() ? null : (locationId.isEmpty() ? Optional.empty() : Optional.of(locationId.get()));
            return this;
        }

        @JsonSetter(value="order_ids", nulls=Nulls.SKIP)
        public Builder orderIds(List<String> orderIds) {
            this.orderIds.clear();
            this.orderIds.addAll(orderIds);
            return this;
        }

        public Builder addOrderIds(String orderIds) {
            this.orderIds.add(orderIds);
            return this;
        }

        public Builder addAllOrderIds(List<String> orderIds) {
            this.orderIds.addAll(orderIds);
            return this;
        }

        public BatchGetOrdersRequest build() {
            return new BatchGetOrdersRequest(this.locationId, this.orderIds, this.additionalProperties);
        }
    }
}

