/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Vendor;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class BatchCreateVendorsRequest {
    private final Map<String, Vendor> vendors;
    private final Map<String, Object> additionalProperties;

    private BatchCreateVendorsRequest(Map<String, Vendor> vendors, Map<String, Object> additionalProperties) {
        this.vendors = vendors;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="vendors")
    public Map<String, Vendor> getVendors() {
        return this.vendors;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof BatchCreateVendorsRequest && this.equalTo((BatchCreateVendorsRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(BatchCreateVendorsRequest other) {
        return this.vendors.equals(other.vendors);
    }

    public int hashCode() {
        return Objects.hash(this.vendors);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Map<String, Vendor> vendors = new LinkedHashMap<String, Vendor>();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(BatchCreateVendorsRequest other) {
            this.vendors(other.getVendors());
            return this;
        }

        @JsonSetter(value="vendors", nulls=Nulls.SKIP)
        public Builder vendors(Map<String, Vendor> vendors) {
            this.vendors.clear();
            this.vendors.putAll(vendors);
            return this;
        }

        public Builder putAllVendors(Map<String, Vendor> vendors) {
            this.vendors.putAll(vendors);
            return this;
        }

        public Builder vendors(String key, Vendor value) {
            this.vendors.put(key, value);
            return this;
        }

        public BatchCreateVendorsRequest build() {
            return new BatchCreateVendorsRequest(this.vendors, this.additionalProperties);
        }
    }
}

