/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.AppointmentSegment;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class Availability {
    private final Optional<String> startAt;
    private final Optional<String> locationId;
    private final Optional<List<AppointmentSegment>> appointmentSegments;
    private final Map<String, Object> additionalProperties;

    private Availability(Optional<String> startAt, Optional<String> locationId, Optional<List<AppointmentSegment>> appointmentSegments, Map<String, Object> additionalProperties) {
        this.startAt = startAt;
        this.locationId = locationId;
        this.appointmentSegments = appointmentSegments;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<String> getStartAt() {
        if (this.startAt == null) {
            return Optional.empty();
        }
        return this.startAt;
    }

    @JsonProperty(value="location_id")
    public Optional<String> getLocationId() {
        return this.locationId;
    }

    @JsonIgnore
    public Optional<List<AppointmentSegment>> getAppointmentSegments() {
        if (this.appointmentSegments == null) {
            return Optional.empty();
        }
        return this.appointmentSegments;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="start_at")
    private Optional<String> _getStartAt() {
        return this.startAt;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="appointment_segments")
    private Optional<List<AppointmentSegment>> _getAppointmentSegments() {
        return this.appointmentSegments;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Availability && this.equalTo((Availability)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Availability other) {
        return this.startAt.equals(other.startAt) && this.locationId.equals(other.locationId) && this.appointmentSegments.equals(other.appointmentSegments);
    }

    public int hashCode() {
        return Objects.hash(this.startAt, this.locationId, this.appointmentSegments);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> startAt = Optional.empty();
        private Optional<String> locationId = Optional.empty();
        private Optional<List<AppointmentSegment>> appointmentSegments = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(Availability other) {
            this.startAt(other.getStartAt());
            this.locationId(other.getLocationId());
            this.appointmentSegments(other.getAppointmentSegments());
            return this;
        }

        @JsonSetter(value="start_at", nulls=Nulls.SKIP)
        public Builder startAt(Optional<String> startAt) {
            this.startAt = startAt;
            return this;
        }

        public Builder startAt(String startAt) {
            this.startAt = Optional.ofNullable(startAt);
            return this;
        }

        public Builder startAt(Nullable<String> startAt) {
            this.startAt = startAt.isNull() ? null : (startAt.isEmpty() ? Optional.empty() : Optional.of(startAt.get()));
            return this;
        }

        @JsonSetter(value="location_id", nulls=Nulls.SKIP)
        public Builder locationId(Optional<String> locationId) {
            this.locationId = locationId;
            return this;
        }

        public Builder locationId(String locationId) {
            this.locationId = Optional.ofNullable(locationId);
            return this;
        }

        @JsonSetter(value="appointment_segments", nulls=Nulls.SKIP)
        public Builder appointmentSegments(Optional<List<AppointmentSegment>> appointmentSegments) {
            this.appointmentSegments = appointmentSegments;
            return this;
        }

        public Builder appointmentSegments(List<AppointmentSegment> appointmentSegments) {
            this.appointmentSegments = Optional.ofNullable(appointmentSegments);
            return this;
        }

        public Builder appointmentSegments(Nullable<List<AppointmentSegment>> appointmentSegments) {
            this.appointmentSegments = appointmentSegments.isNull() ? null : (appointmentSegments.isEmpty() ? Optional.empty() : Optional.of(appointmentSegments.get()));
            return this;
        }

        public Availability build() {
            return new Availability(this.startAt, this.locationId, this.appointmentSegments, this.additionalProperties);
        }
    }
}

