/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.ApplicationDetailsExternalSquareProduct;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ApplicationDetails {
    private final Optional<ApplicationDetailsExternalSquareProduct> squareProduct;
    private final Optional<String> applicationId;
    private final Map<String, Object> additionalProperties;

    private ApplicationDetails(Optional<ApplicationDetailsExternalSquareProduct> squareProduct, Optional<String> applicationId, Map<String, Object> additionalProperties) {
        this.squareProduct = squareProduct;
        this.applicationId = applicationId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="square_product")
    public Optional<ApplicationDetailsExternalSquareProduct> getSquareProduct() {
        return this.squareProduct;
    }

    @JsonIgnore
    public Optional<String> getApplicationId() {
        if (this.applicationId == null) {
            return Optional.empty();
        }
        return this.applicationId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="application_id")
    private Optional<String> _getApplicationId() {
        return this.applicationId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ApplicationDetails && this.equalTo((ApplicationDetails)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ApplicationDetails other) {
        return this.squareProduct.equals(other.squareProduct) && this.applicationId.equals(other.applicationId);
    }

    public int hashCode() {
        return Objects.hash(this.squareProduct, this.applicationId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<ApplicationDetailsExternalSquareProduct> squareProduct = Optional.empty();
        private Optional<String> applicationId = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ApplicationDetails other) {
            this.squareProduct(other.getSquareProduct());
            this.applicationId(other.getApplicationId());
            return this;
        }

        @JsonSetter(value="square_product", nulls=Nulls.SKIP)
        public Builder squareProduct(Optional<ApplicationDetailsExternalSquareProduct> squareProduct) {
            this.squareProduct = squareProduct;
            return this;
        }

        public Builder squareProduct(ApplicationDetailsExternalSquareProduct squareProduct) {
            this.squareProduct = Optional.ofNullable(squareProduct);
            return this;
        }

        @JsonSetter(value="application_id", nulls=Nulls.SKIP)
        public Builder applicationId(Optional<String> applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public Builder applicationId(String applicationId) {
            this.applicationId = Optional.ofNullable(applicationId);
            return this;
        }

        public Builder applicationId(Nullable<String> applicationId) {
            this.applicationId = applicationId.isNull() ? null : (applicationId.isEmpty() ? Optional.empty() : Optional.of(applicationId.get()));
            return this;
        }

        public ApplicationDetails build() {
            return new ApplicationDetails(this.squareProduct, this.applicationId, this.additionalProperties);
        }
    }
}

