/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Error;
import com.squareup.square.types.LoyaltyEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class AdjustLoyaltyPointsResponse {
    private final Optional<List<Error>> errors;
    private final Optional<LoyaltyEvent> event;
    private final Map<String, Object> additionalProperties;

    private AdjustLoyaltyPointsResponse(Optional<List<Error>> errors, Optional<LoyaltyEvent> event, Map<String, Object> additionalProperties) {
        this.errors = errors;
        this.event = event;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="errors")
    public Optional<List<Error>> getErrors() {
        return this.errors;
    }

    @JsonProperty(value="event")
    public Optional<LoyaltyEvent> getEvent() {
        return this.event;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof AdjustLoyaltyPointsResponse && this.equalTo((AdjustLoyaltyPointsResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(AdjustLoyaltyPointsResponse other) {
        return this.errors.equals(other.errors) && this.event.equals(other.event);
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.event);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<List<Error>> errors = Optional.empty();
        private Optional<LoyaltyEvent> event = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(AdjustLoyaltyPointsResponse other) {
            this.errors(other.getErrors());
            this.event(other.getEvent());
            return this;
        }

        @JsonSetter(value="errors", nulls=Nulls.SKIP)
        public Builder errors(Optional<List<Error>> errors) {
            this.errors = errors;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = Optional.ofNullable(errors);
            return this;
        }

        @JsonSetter(value="event", nulls=Nulls.SKIP)
        public Builder event(Optional<LoyaltyEvent> event) {
            this.event = event;
            return this;
        }

        public Builder event(LoyaltyEvent event) {
            this.event = Optional.ofNullable(event);
            return this;
        }

        public AdjustLoyaltyPointsResponse build() {
            return new AdjustLoyaltyPointsResponse(this.errors, this.event, this.additionalProperties);
        }
    }
}

