/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Country;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class Address {
    private final Optional<String> addressLine1;
    private final Optional<String> addressLine2;
    private final Optional<String> addressLine3;
    private final Optional<String> locality;
    private final Optional<String> sublocality;
    private final Optional<String> sublocality2;
    private final Optional<String> sublocality3;
    private final Optional<String> administrativeDistrictLevel1;
    private final Optional<String> administrativeDistrictLevel2;
    private final Optional<String> administrativeDistrictLevel3;
    private final Optional<String> postalCode;
    private final Optional<Country> country;
    private final Optional<String> firstName;
    private final Optional<String> lastName;
    private final Map<String, Object> additionalProperties;

    private Address(Optional<String> addressLine1, Optional<String> addressLine2, Optional<String> addressLine3, Optional<String> locality, Optional<String> sublocality, Optional<String> sublocality2, Optional<String> sublocality3, Optional<String> administrativeDistrictLevel1, Optional<String> administrativeDistrictLevel2, Optional<String> administrativeDistrictLevel3, Optional<String> postalCode, Optional<Country> country, Optional<String> firstName, Optional<String> lastName, Map<String, Object> additionalProperties) {
        this.addressLine1 = addressLine1;
        this.addressLine2 = addressLine2;
        this.addressLine3 = addressLine3;
        this.locality = locality;
        this.sublocality = sublocality;
        this.sublocality2 = sublocality2;
        this.sublocality3 = sublocality3;
        this.administrativeDistrictLevel1 = administrativeDistrictLevel1;
        this.administrativeDistrictLevel2 = administrativeDistrictLevel2;
        this.administrativeDistrictLevel3 = administrativeDistrictLevel3;
        this.postalCode = postalCode;
        this.country = country;
        this.firstName = firstName;
        this.lastName = lastName;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<String> getAddressLine1() {
        if (this.addressLine1 == null) {
            return Optional.empty();
        }
        return this.addressLine1;
    }

    @JsonIgnore
    public Optional<String> getAddressLine2() {
        if (this.addressLine2 == null) {
            return Optional.empty();
        }
        return this.addressLine2;
    }

    @JsonIgnore
    public Optional<String> getAddressLine3() {
        if (this.addressLine3 == null) {
            return Optional.empty();
        }
        return this.addressLine3;
    }

    @JsonIgnore
    public Optional<String> getLocality() {
        if (this.locality == null) {
            return Optional.empty();
        }
        return this.locality;
    }

    @JsonIgnore
    public Optional<String> getSublocality() {
        if (this.sublocality == null) {
            return Optional.empty();
        }
        return this.sublocality;
    }

    @JsonIgnore
    public Optional<String> getSublocality2() {
        if (this.sublocality2 == null) {
            return Optional.empty();
        }
        return this.sublocality2;
    }

    @JsonIgnore
    public Optional<String> getSublocality3() {
        if (this.sublocality3 == null) {
            return Optional.empty();
        }
        return this.sublocality3;
    }

    @JsonIgnore
    public Optional<String> getAdministrativeDistrictLevel1() {
        if (this.administrativeDistrictLevel1 == null) {
            return Optional.empty();
        }
        return this.administrativeDistrictLevel1;
    }

    @JsonIgnore
    public Optional<String> getAdministrativeDistrictLevel2() {
        if (this.administrativeDistrictLevel2 == null) {
            return Optional.empty();
        }
        return this.administrativeDistrictLevel2;
    }

    @JsonIgnore
    public Optional<String> getAdministrativeDistrictLevel3() {
        if (this.administrativeDistrictLevel3 == null) {
            return Optional.empty();
        }
        return this.administrativeDistrictLevel3;
    }

    @JsonIgnore
    public Optional<String> getPostalCode() {
        if (this.postalCode == null) {
            return Optional.empty();
        }
        return this.postalCode;
    }

    @JsonProperty(value="country")
    public Optional<Country> getCountry() {
        return this.country;
    }

    @JsonIgnore
    public Optional<String> getFirstName() {
        if (this.firstName == null) {
            return Optional.empty();
        }
        return this.firstName;
    }

    @JsonIgnore
    public Optional<String> getLastName() {
        if (this.lastName == null) {
            return Optional.empty();
        }
        return this.lastName;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="address_line_1")
    private Optional<String> _getAddressLine1() {
        return this.addressLine1;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="address_line_2")
    private Optional<String> _getAddressLine2() {
        return this.addressLine2;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="address_line_3")
    private Optional<String> _getAddressLine3() {
        return this.addressLine3;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="locality")
    private Optional<String> _getLocality() {
        return this.locality;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="sublocality")
    private Optional<String> _getSublocality() {
        return this.sublocality;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="sublocality_2")
    private Optional<String> _getSublocality2() {
        return this.sublocality2;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="sublocality_3")
    private Optional<String> _getSublocality3() {
        return this.sublocality3;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="administrative_district_level_1")
    private Optional<String> _getAdministrativeDistrictLevel1() {
        return this.administrativeDistrictLevel1;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="administrative_district_level_2")
    private Optional<String> _getAdministrativeDistrictLevel2() {
        return this.administrativeDistrictLevel2;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="administrative_district_level_3")
    private Optional<String> _getAdministrativeDistrictLevel3() {
        return this.administrativeDistrictLevel3;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="postal_code")
    private Optional<String> _getPostalCode() {
        return this.postalCode;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="first_name")
    private Optional<String> _getFirstName() {
        return this.firstName;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="last_name")
    private Optional<String> _getLastName() {
        return this.lastName;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Address && this.equalTo((Address)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Address other) {
        return this.addressLine1.equals(other.addressLine1) && this.addressLine2.equals(other.addressLine2) && this.addressLine3.equals(other.addressLine3) && this.locality.equals(other.locality) && this.sublocality.equals(other.sublocality) && this.sublocality2.equals(other.sublocality2) && this.sublocality3.equals(other.sublocality3) && this.administrativeDistrictLevel1.equals(other.administrativeDistrictLevel1) && this.administrativeDistrictLevel2.equals(other.administrativeDistrictLevel2) && this.administrativeDistrictLevel3.equals(other.administrativeDistrictLevel3) && this.postalCode.equals(other.postalCode) && this.country.equals(other.country) && this.firstName.equals(other.firstName) && this.lastName.equals(other.lastName);
    }

    public int hashCode() {
        return Objects.hash(this.addressLine1, this.addressLine2, this.addressLine3, this.locality, this.sublocality, this.sublocality2, this.sublocality3, this.administrativeDistrictLevel1, this.administrativeDistrictLevel2, this.administrativeDistrictLevel3, this.postalCode, this.country, this.firstName, this.lastName);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> addressLine1 = Optional.empty();
        private Optional<String> addressLine2 = Optional.empty();
        private Optional<String> addressLine3 = Optional.empty();
        private Optional<String> locality = Optional.empty();
        private Optional<String> sublocality = Optional.empty();
        private Optional<String> sublocality2 = Optional.empty();
        private Optional<String> sublocality3 = Optional.empty();
        private Optional<String> administrativeDistrictLevel1 = Optional.empty();
        private Optional<String> administrativeDistrictLevel2 = Optional.empty();
        private Optional<String> administrativeDistrictLevel3 = Optional.empty();
        private Optional<String> postalCode = Optional.empty();
        private Optional<Country> country = Optional.empty();
        private Optional<String> firstName = Optional.empty();
        private Optional<String> lastName = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(Address other) {
            this.addressLine1(other.getAddressLine1());
            this.addressLine2(other.getAddressLine2());
            this.addressLine3(other.getAddressLine3());
            this.locality(other.getLocality());
            this.sublocality(other.getSublocality());
            this.sublocality2(other.getSublocality2());
            this.sublocality3(other.getSublocality3());
            this.administrativeDistrictLevel1(other.getAdministrativeDistrictLevel1());
            this.administrativeDistrictLevel2(other.getAdministrativeDistrictLevel2());
            this.administrativeDistrictLevel3(other.getAdministrativeDistrictLevel3());
            this.postalCode(other.getPostalCode());
            this.country(other.getCountry());
            this.firstName(other.getFirstName());
            this.lastName(other.getLastName());
            return this;
        }

        @JsonSetter(value="address_line_1", nulls=Nulls.SKIP)
        public Builder addressLine1(Optional<String> addressLine1) {
            this.addressLine1 = addressLine1;
            return this;
        }

        public Builder addressLine1(String addressLine1) {
            this.addressLine1 = Optional.ofNullable(addressLine1);
            return this;
        }

        public Builder addressLine1(Nullable<String> addressLine1) {
            this.addressLine1 = addressLine1.isNull() ? null : (addressLine1.isEmpty() ? Optional.empty() : Optional.of(addressLine1.get()));
            return this;
        }

        @JsonSetter(value="address_line_2", nulls=Nulls.SKIP)
        public Builder addressLine2(Optional<String> addressLine2) {
            this.addressLine2 = addressLine2;
            return this;
        }

        public Builder addressLine2(String addressLine2) {
            this.addressLine2 = Optional.ofNullable(addressLine2);
            return this;
        }

        public Builder addressLine2(Nullable<String> addressLine2) {
            this.addressLine2 = addressLine2.isNull() ? null : (addressLine2.isEmpty() ? Optional.empty() : Optional.of(addressLine2.get()));
            return this;
        }

        @JsonSetter(value="address_line_3", nulls=Nulls.SKIP)
        public Builder addressLine3(Optional<String> addressLine3) {
            this.addressLine3 = addressLine3;
            return this;
        }

        public Builder addressLine3(String addressLine3) {
            this.addressLine3 = Optional.ofNullable(addressLine3);
            return this;
        }

        public Builder addressLine3(Nullable<String> addressLine3) {
            this.addressLine3 = addressLine3.isNull() ? null : (addressLine3.isEmpty() ? Optional.empty() : Optional.of(addressLine3.get()));
            return this;
        }

        @JsonSetter(value="locality", nulls=Nulls.SKIP)
        public Builder locality(Optional<String> locality) {
            this.locality = locality;
            return this;
        }

        public Builder locality(String locality) {
            this.locality = Optional.ofNullable(locality);
            return this;
        }

        public Builder locality(Nullable<String> locality) {
            this.locality = locality.isNull() ? null : (locality.isEmpty() ? Optional.empty() : Optional.of(locality.get()));
            return this;
        }

        @JsonSetter(value="sublocality", nulls=Nulls.SKIP)
        public Builder sublocality(Optional<String> sublocality) {
            this.sublocality = sublocality;
            return this;
        }

        public Builder sublocality(String sublocality) {
            this.sublocality = Optional.ofNullable(sublocality);
            return this;
        }

        public Builder sublocality(Nullable<String> sublocality) {
            this.sublocality = sublocality.isNull() ? null : (sublocality.isEmpty() ? Optional.empty() : Optional.of(sublocality.get()));
            return this;
        }

        @JsonSetter(value="sublocality_2", nulls=Nulls.SKIP)
        public Builder sublocality2(Optional<String> sublocality2) {
            this.sublocality2 = sublocality2;
            return this;
        }

        public Builder sublocality2(String sublocality2) {
            this.sublocality2 = Optional.ofNullable(sublocality2);
            return this;
        }

        public Builder sublocality2(Nullable<String> sublocality2) {
            this.sublocality2 = sublocality2.isNull() ? null : (sublocality2.isEmpty() ? Optional.empty() : Optional.of(sublocality2.get()));
            return this;
        }

        @JsonSetter(value="sublocality_3", nulls=Nulls.SKIP)
        public Builder sublocality3(Optional<String> sublocality3) {
            this.sublocality3 = sublocality3;
            return this;
        }

        public Builder sublocality3(String sublocality3) {
            this.sublocality3 = Optional.ofNullable(sublocality3);
            return this;
        }

        public Builder sublocality3(Nullable<String> sublocality3) {
            this.sublocality3 = sublocality3.isNull() ? null : (sublocality3.isEmpty() ? Optional.empty() : Optional.of(sublocality3.get()));
            return this;
        }

        @JsonSetter(value="administrative_district_level_1", nulls=Nulls.SKIP)
        public Builder administrativeDistrictLevel1(Optional<String> administrativeDistrictLevel1) {
            this.administrativeDistrictLevel1 = administrativeDistrictLevel1;
            return this;
        }

        public Builder administrativeDistrictLevel1(String administrativeDistrictLevel1) {
            this.administrativeDistrictLevel1 = Optional.ofNullable(administrativeDistrictLevel1);
            return this;
        }

        public Builder administrativeDistrictLevel1(Nullable<String> administrativeDistrictLevel1) {
            this.administrativeDistrictLevel1 = administrativeDistrictLevel1.isNull() ? null : (administrativeDistrictLevel1.isEmpty() ? Optional.empty() : Optional.of(administrativeDistrictLevel1.get()));
            return this;
        }

        @JsonSetter(value="administrative_district_level_2", nulls=Nulls.SKIP)
        public Builder administrativeDistrictLevel2(Optional<String> administrativeDistrictLevel2) {
            this.administrativeDistrictLevel2 = administrativeDistrictLevel2;
            return this;
        }

        public Builder administrativeDistrictLevel2(String administrativeDistrictLevel2) {
            this.administrativeDistrictLevel2 = Optional.ofNullable(administrativeDistrictLevel2);
            return this;
        }

        public Builder administrativeDistrictLevel2(Nullable<String> administrativeDistrictLevel2) {
            this.administrativeDistrictLevel2 = administrativeDistrictLevel2.isNull() ? null : (administrativeDistrictLevel2.isEmpty() ? Optional.empty() : Optional.of(administrativeDistrictLevel2.get()));
            return this;
        }

        @JsonSetter(value="administrative_district_level_3", nulls=Nulls.SKIP)
        public Builder administrativeDistrictLevel3(Optional<String> administrativeDistrictLevel3) {
            this.administrativeDistrictLevel3 = administrativeDistrictLevel3;
            return this;
        }

        public Builder administrativeDistrictLevel3(String administrativeDistrictLevel3) {
            this.administrativeDistrictLevel3 = Optional.ofNullable(administrativeDistrictLevel3);
            return this;
        }

        public Builder administrativeDistrictLevel3(Nullable<String> administrativeDistrictLevel3) {
            this.administrativeDistrictLevel3 = administrativeDistrictLevel3.isNull() ? null : (administrativeDistrictLevel3.isEmpty() ? Optional.empty() : Optional.of(administrativeDistrictLevel3.get()));
            return this;
        }

        @JsonSetter(value="postal_code", nulls=Nulls.SKIP)
        public Builder postalCode(Optional<String> postalCode) {
            this.postalCode = postalCode;
            return this;
        }

        public Builder postalCode(String postalCode) {
            this.postalCode = Optional.ofNullable(postalCode);
            return this;
        }

        public Builder postalCode(Nullable<String> postalCode) {
            this.postalCode = postalCode.isNull() ? null : (postalCode.isEmpty() ? Optional.empty() : Optional.of(postalCode.get()));
            return this;
        }

        @JsonSetter(value="country", nulls=Nulls.SKIP)
        public Builder country(Optional<Country> country) {
            this.country = country;
            return this;
        }

        public Builder country(Country country) {
            this.country = Optional.ofNullable(country);
            return this;
        }

        @JsonSetter(value="first_name", nulls=Nulls.SKIP)
        public Builder firstName(Optional<String> firstName) {
            this.firstName = firstName;
            return this;
        }

        public Builder firstName(String firstName) {
            this.firstName = Optional.ofNullable(firstName);
            return this;
        }

        public Builder firstName(Nullable<String> firstName) {
            this.firstName = firstName.isNull() ? null : (firstName.isEmpty() ? Optional.empty() : Optional.of(firstName.get()));
            return this;
        }

        @JsonSetter(value="last_name", nulls=Nulls.SKIP)
        public Builder lastName(Optional<String> lastName) {
            this.lastName = lastName;
            return this;
        }

        public Builder lastName(String lastName) {
            this.lastName = Optional.ofNullable(lastName);
            return this;
        }

        public Builder lastName(Nullable<String> lastName) {
            this.lastName = lastName.isNull() ? null : (lastName.isEmpty() ? Optional.empty() : Optional.of(lastName.get()));
            return this;
        }

        public Address build() {
            return new Address(this.addressLine1, this.addressLine2, this.addressLine3, this.locality, this.sublocality, this.sublocality2, this.sublocality3, this.administrativeDistrictLevel1, this.administrativeDistrictLevel2, this.administrativeDistrictLevel3, this.postalCode, this.country, this.firstName, this.lastName, this.additionalProperties);
        }
    }
}

