/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.teammembers.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.WageSetting;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class UpdateWageSettingRequest {
    private final String teamMemberId;
    private final WageSetting wageSetting;
    private final Map<String, Object> additionalProperties;

    private UpdateWageSettingRequest(String teamMemberId, WageSetting wageSetting, Map<String, Object> additionalProperties) {
        this.teamMemberId = teamMemberId;
        this.wageSetting = wageSetting;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="team_member_id")
    public String getTeamMemberId() {
        return this.teamMemberId;
    }

    @JsonProperty(value="wage_setting")
    public WageSetting getWageSetting() {
        return this.wageSetting;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof UpdateWageSettingRequest && this.equalTo((UpdateWageSettingRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(UpdateWageSettingRequest other) {
        return this.teamMemberId.equals(other.teamMemberId) && this.wageSetting.equals(other.wageSetting);
    }

    public int hashCode() {
        return Objects.hash(this.teamMemberId, this.wageSetting);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TeamMemberIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements TeamMemberIdStage,
    WageSettingStage,
    _FinalStage {
        private String teamMemberId;
        private WageSetting wageSetting;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(UpdateWageSettingRequest other) {
            this.teamMemberId(other.getTeamMemberId());
            this.wageSetting(other.getWageSetting());
            return this;
        }

        @Override
        @JsonSetter(value="team_member_id")
        public WageSettingStage teamMemberId(@NotNull String teamMemberId) {
            this.teamMemberId = Objects.requireNonNull(teamMemberId, "teamMemberId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="wage_setting")
        public _FinalStage wageSetting(@NotNull WageSetting wageSetting) {
            this.wageSetting = Objects.requireNonNull(wageSetting, "wageSetting must not be null");
            return this;
        }

        @Override
        public UpdateWageSettingRequest build() {
            return new UpdateWageSettingRequest(this.teamMemberId, this.wageSetting, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public UpdateWageSettingRequest build();
    }

    public static interface WageSettingStage {
        public _FinalStage wageSetting(@NotNull WageSetting var1);
    }

    public static interface TeamMemberIdStage {
        public WageSettingStage teamMemberId(@NotNull String var1);

        public Builder from(UpdateWageSettingRequest var1);
    }
}

