/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.orders.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.CustomAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class UpsertOrderCustomAttributeRequest {
    private final String orderId;
    private final String customAttributeKey;
    private final CustomAttribute customAttribute;
    private final Optional<String> idempotencyKey;
    private final Map<String, Object> additionalProperties;

    private UpsertOrderCustomAttributeRequest(String orderId, String customAttributeKey, CustomAttribute customAttribute, Optional<String> idempotencyKey, Map<String, Object> additionalProperties) {
        this.orderId = orderId;
        this.customAttributeKey = customAttributeKey;
        this.customAttribute = customAttribute;
        this.idempotencyKey = idempotencyKey;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="order_id")
    public String getOrderId() {
        return this.orderId;
    }

    @JsonProperty(value="custom_attribute_key")
    public String getCustomAttributeKey() {
        return this.customAttributeKey;
    }

    @JsonProperty(value="custom_attribute")
    public CustomAttribute getCustomAttribute() {
        return this.customAttribute;
    }

    @JsonIgnore
    public Optional<String> getIdempotencyKey() {
        if (this.idempotencyKey == null) {
            return Optional.empty();
        }
        return this.idempotencyKey;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="idempotency_key")
    private Optional<String> _getIdempotencyKey() {
        return this.idempotencyKey;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof UpsertOrderCustomAttributeRequest && this.equalTo((UpsertOrderCustomAttributeRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(UpsertOrderCustomAttributeRequest other) {
        return this.orderId.equals(other.orderId) && this.customAttributeKey.equals(other.customAttributeKey) && this.customAttribute.equals(other.customAttribute) && this.idempotencyKey.equals(other.idempotencyKey);
    }

    public int hashCode() {
        return Objects.hash(this.orderId, this.customAttributeKey, this.customAttribute, this.idempotencyKey);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static OrderIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements OrderIdStage,
    CustomAttributeKeyStage,
    CustomAttributeStage,
    _FinalStage {
        private String orderId;
        private String customAttributeKey;
        private CustomAttribute customAttribute;
        private Optional<String> idempotencyKey = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(UpsertOrderCustomAttributeRequest other) {
            this.orderId(other.getOrderId());
            this.customAttributeKey(other.getCustomAttributeKey());
            this.customAttribute(other.getCustomAttribute());
            this.idempotencyKey(other.getIdempotencyKey());
            return this;
        }

        @Override
        @JsonSetter(value="order_id")
        public CustomAttributeKeyStage orderId(@NotNull String orderId) {
            this.orderId = Objects.requireNonNull(orderId, "orderId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="custom_attribute_key")
        public CustomAttributeStage customAttributeKey(@NotNull String customAttributeKey) {
            this.customAttributeKey = Objects.requireNonNull(customAttributeKey, "customAttributeKey must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="custom_attribute")
        public _FinalStage customAttribute(@NotNull CustomAttribute customAttribute) {
            this.customAttribute = Objects.requireNonNull(customAttribute, "customAttribute must not be null");
            return this;
        }

        @Override
        public _FinalStage idempotencyKey(Nullable<String> idempotencyKey) {
            this.idempotencyKey = idempotencyKey.isNull() ? null : (idempotencyKey.isEmpty() ? Optional.empty() : Optional.of(idempotencyKey.get()));
            return this;
        }

        @Override
        public _FinalStage idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = Optional.ofNullable(idempotencyKey);
            return this;
        }

        @Override
        @JsonSetter(value="idempotency_key", nulls=Nulls.SKIP)
        public _FinalStage idempotencyKey(Optional<String> idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        @Override
        public UpsertOrderCustomAttributeRequest build() {
            return new UpsertOrderCustomAttributeRequest(this.orderId, this.customAttributeKey, this.customAttribute, this.idempotencyKey, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public UpsertOrderCustomAttributeRequest build();

        public _FinalStage idempotencyKey(Optional<String> var1);

        public _FinalStage idempotencyKey(String var1);

        public _FinalStage idempotencyKey(Nullable<String> var1);
    }

    public static interface CustomAttributeStage {
        public _FinalStage customAttribute(@NotNull CustomAttribute var1);
    }

    public static interface CustomAttributeKeyStage {
        public CustomAttributeStage customAttributeKey(@NotNull String var1);
    }

    public static interface OrderIdStage {
        public CustomAttributeKeyStage orderId(@NotNull String var1);

        public Builder from(UpsertOrderCustomAttributeRequest var1);
    }
}

