/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.orders;

import com.squareup.square.core.ClientOptions;
import com.squareup.square.core.RequestOptions;
import com.squareup.square.core.SyncPagingIterable;
import com.squareup.square.orders.AsyncRawCustomAttributesClient;
import com.squareup.square.orders.types.BulkDeleteOrderCustomAttributesRequest;
import com.squareup.square.orders.types.BulkUpsertOrderCustomAttributesRequest;
import com.squareup.square.orders.types.DeleteCustomAttributesRequest;
import com.squareup.square.orders.types.GetCustomAttributesRequest;
import com.squareup.square.orders.types.ListCustomAttributesRequest;
import com.squareup.square.orders.types.UpsertOrderCustomAttributeRequest;
import com.squareup.square.types.BulkDeleteOrderCustomAttributesResponse;
import com.squareup.square.types.BulkUpsertOrderCustomAttributesResponse;
import com.squareup.square.types.CustomAttribute;
import com.squareup.square.types.DeleteOrderCustomAttributeResponse;
import com.squareup.square.types.RetrieveOrderCustomAttributeResponse;
import com.squareup.square.types.UpsertOrderCustomAttributeResponse;
import java.util.concurrent.CompletableFuture;

public class AsyncCustomAttributesClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawCustomAttributesClient rawClient;

    public AsyncCustomAttributesClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawCustomAttributesClient(clientOptions);
    }

    public AsyncRawCustomAttributesClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<BulkDeleteOrderCustomAttributesResponse> batchDelete(BulkDeleteOrderCustomAttributesRequest request) {
        return this.rawClient.batchDelete(request).thenApply(response -> (BulkDeleteOrderCustomAttributesResponse)response.body());
    }

    public CompletableFuture<BulkDeleteOrderCustomAttributesResponse> batchDelete(BulkDeleteOrderCustomAttributesRequest request, RequestOptions requestOptions) {
        return this.rawClient.batchDelete(request, requestOptions).thenApply(response -> (BulkDeleteOrderCustomAttributesResponse)response.body());
    }

    public CompletableFuture<BulkUpsertOrderCustomAttributesResponse> batchUpsert(BulkUpsertOrderCustomAttributesRequest request) {
        return this.rawClient.batchUpsert(request).thenApply(response -> (BulkUpsertOrderCustomAttributesResponse)response.body());
    }

    public CompletableFuture<BulkUpsertOrderCustomAttributesResponse> batchUpsert(BulkUpsertOrderCustomAttributesRequest request, RequestOptions requestOptions) {
        return this.rawClient.batchUpsert(request, requestOptions).thenApply(response -> (BulkUpsertOrderCustomAttributesResponse)response.body());
    }

    public CompletableFuture<SyncPagingIterable<CustomAttribute>> list(ListCustomAttributesRequest request) {
        return this.rawClient.list(request).thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<SyncPagingIterable<CustomAttribute>> list(ListCustomAttributesRequest request, RequestOptions requestOptions) {
        return this.rawClient.list(request, requestOptions).thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<RetrieveOrderCustomAttributeResponse> get(GetCustomAttributesRequest request) {
        return this.rawClient.get(request).thenApply(response -> (RetrieveOrderCustomAttributeResponse)response.body());
    }

    public CompletableFuture<RetrieveOrderCustomAttributeResponse> get(GetCustomAttributesRequest request, RequestOptions requestOptions) {
        return this.rawClient.get(request, requestOptions).thenApply(response -> (RetrieveOrderCustomAttributeResponse)response.body());
    }

    public CompletableFuture<UpsertOrderCustomAttributeResponse> upsert(UpsertOrderCustomAttributeRequest request) {
        return this.rawClient.upsert(request).thenApply(response -> (UpsertOrderCustomAttributeResponse)response.body());
    }

    public CompletableFuture<UpsertOrderCustomAttributeResponse> upsert(UpsertOrderCustomAttributeRequest request, RequestOptions requestOptions) {
        return this.rawClient.upsert(request, requestOptions).thenApply(response -> (UpsertOrderCustomAttributeResponse)response.body());
    }

    public CompletableFuture<DeleteOrderCustomAttributeResponse> delete(DeleteCustomAttributesRequest request) {
        return this.rawClient.delete(request).thenApply(response -> (DeleteOrderCustomAttributeResponse)response.body());
    }

    public CompletableFuture<DeleteOrderCustomAttributeResponse> delete(DeleteCustomAttributesRequest request, RequestOptions requestOptions) {
        return this.rawClient.delete(request, requestOptions).thenApply(response -> (DeleteOrderCustomAttributeResponse)response.body());
    }
}

