/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.orders;

import com.squareup.square.core.ClientOptions;
import com.squareup.square.core.RequestOptions;
import com.squareup.square.core.SyncPagingIterable;
import com.squareup.square.orders.AsyncRawCustomAttributeDefinitionsClient;
import com.squareup.square.orders.types.CreateOrderCustomAttributeDefinitionRequest;
import com.squareup.square.orders.types.DeleteCustomAttributeDefinitionsRequest;
import com.squareup.square.orders.types.GetCustomAttributeDefinitionsRequest;
import com.squareup.square.orders.types.ListCustomAttributeDefinitionsRequest;
import com.squareup.square.orders.types.UpdateOrderCustomAttributeDefinitionRequest;
import com.squareup.square.types.CreateOrderCustomAttributeDefinitionResponse;
import com.squareup.square.types.CustomAttributeDefinition;
import com.squareup.square.types.DeleteOrderCustomAttributeDefinitionResponse;
import com.squareup.square.types.RetrieveOrderCustomAttributeDefinitionResponse;
import com.squareup.square.types.UpdateOrderCustomAttributeDefinitionResponse;
import java.util.concurrent.CompletableFuture;

public class AsyncCustomAttributeDefinitionsClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawCustomAttributeDefinitionsClient rawClient;

    public AsyncCustomAttributeDefinitionsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawCustomAttributeDefinitionsClient(clientOptions);
    }

    public AsyncRawCustomAttributeDefinitionsClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<SyncPagingIterable<CustomAttributeDefinition>> list() {
        return this.rawClient.list().thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<SyncPagingIterable<CustomAttributeDefinition>> list(ListCustomAttributeDefinitionsRequest request) {
        return this.rawClient.list(request).thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<SyncPagingIterable<CustomAttributeDefinition>> list(ListCustomAttributeDefinitionsRequest request, RequestOptions requestOptions) {
        return this.rawClient.list(request, requestOptions).thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<CreateOrderCustomAttributeDefinitionResponse> create(CreateOrderCustomAttributeDefinitionRequest request) {
        return this.rawClient.create(request).thenApply(response -> (CreateOrderCustomAttributeDefinitionResponse)response.body());
    }

    public CompletableFuture<CreateOrderCustomAttributeDefinitionResponse> create(CreateOrderCustomAttributeDefinitionRequest request, RequestOptions requestOptions) {
        return this.rawClient.create(request, requestOptions).thenApply(response -> (CreateOrderCustomAttributeDefinitionResponse)response.body());
    }

    public CompletableFuture<RetrieveOrderCustomAttributeDefinitionResponse> get(GetCustomAttributeDefinitionsRequest request) {
        return this.rawClient.get(request).thenApply(response -> (RetrieveOrderCustomAttributeDefinitionResponse)response.body());
    }

    public CompletableFuture<RetrieveOrderCustomAttributeDefinitionResponse> get(GetCustomAttributeDefinitionsRequest request, RequestOptions requestOptions) {
        return this.rawClient.get(request, requestOptions).thenApply(response -> (RetrieveOrderCustomAttributeDefinitionResponse)response.body());
    }

    public CompletableFuture<UpdateOrderCustomAttributeDefinitionResponse> update(UpdateOrderCustomAttributeDefinitionRequest request) {
        return this.rawClient.update(request).thenApply(response -> (UpdateOrderCustomAttributeDefinitionResponse)response.body());
    }

    public CompletableFuture<UpdateOrderCustomAttributeDefinitionResponse> update(UpdateOrderCustomAttributeDefinitionRequest request, RequestOptions requestOptions) {
        return this.rawClient.update(request, requestOptions).thenApply(response -> (UpdateOrderCustomAttributeDefinitionResponse)response.body());
    }

    public CompletableFuture<DeleteOrderCustomAttributeDefinitionResponse> delete(DeleteCustomAttributeDefinitionsRequest request) {
        return this.rawClient.delete(request).thenApply(response -> (DeleteOrderCustomAttributeDefinitionResponse)response.body());
    }

    public CompletableFuture<DeleteOrderCustomAttributeDefinitionResponse> delete(DeleteCustomAttributeDefinitionsRequest request, RequestOptions requestOptions) {
        return this.rawClient.delete(request, requestOptions).thenApply(response -> (DeleteOrderCustomAttributeDefinitionResponse)response.body());
    }
}

