/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.loyalty.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.LoyaltyEventAdjustPoints;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class AdjustLoyaltyPointsRequest {
    private final String accountId;
    private final String idempotencyKey;
    private final LoyaltyEventAdjustPoints adjustPoints;
    private final Optional<Boolean> allowNegativeBalance;
    private final Map<String, Object> additionalProperties;

    private AdjustLoyaltyPointsRequest(String accountId, String idempotencyKey, LoyaltyEventAdjustPoints adjustPoints, Optional<Boolean> allowNegativeBalance, Map<String, Object> additionalProperties) {
        this.accountId = accountId;
        this.idempotencyKey = idempotencyKey;
        this.adjustPoints = adjustPoints;
        this.allowNegativeBalance = allowNegativeBalance;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="account_id")
    public String getAccountId() {
        return this.accountId;
    }

    @JsonProperty(value="idempotency_key")
    public String getIdempotencyKey() {
        return this.idempotencyKey;
    }

    @JsonProperty(value="adjust_points")
    public LoyaltyEventAdjustPoints getAdjustPoints() {
        return this.adjustPoints;
    }

    @JsonIgnore
    public Optional<Boolean> getAllowNegativeBalance() {
        if (this.allowNegativeBalance == null) {
            return Optional.empty();
        }
        return this.allowNegativeBalance;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="allow_negative_balance")
    private Optional<Boolean> _getAllowNegativeBalance() {
        return this.allowNegativeBalance;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof AdjustLoyaltyPointsRequest && this.equalTo((AdjustLoyaltyPointsRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(AdjustLoyaltyPointsRequest other) {
        return this.accountId.equals(other.accountId) && this.idempotencyKey.equals(other.idempotencyKey) && this.adjustPoints.equals(other.adjustPoints) && this.allowNegativeBalance.equals(other.allowNegativeBalance);
    }

    public int hashCode() {
        return Objects.hash(this.accountId, this.idempotencyKey, this.adjustPoints, this.allowNegativeBalance);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static AccountIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements AccountIdStage,
    IdempotencyKeyStage,
    AdjustPointsStage,
    _FinalStage {
        private String accountId;
        private String idempotencyKey;
        private LoyaltyEventAdjustPoints adjustPoints;
        private Optional<Boolean> allowNegativeBalance = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(AdjustLoyaltyPointsRequest other) {
            this.accountId(other.getAccountId());
            this.idempotencyKey(other.getIdempotencyKey());
            this.adjustPoints(other.getAdjustPoints());
            this.allowNegativeBalance(other.getAllowNegativeBalance());
            return this;
        }

        @Override
        @JsonSetter(value="account_id")
        public IdempotencyKeyStage accountId(@NotNull String accountId) {
            this.accountId = Objects.requireNonNull(accountId, "accountId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="idempotency_key")
        public AdjustPointsStage idempotencyKey(@NotNull String idempotencyKey) {
            this.idempotencyKey = Objects.requireNonNull(idempotencyKey, "idempotencyKey must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="adjust_points")
        public _FinalStage adjustPoints(@NotNull LoyaltyEventAdjustPoints adjustPoints) {
            this.adjustPoints = Objects.requireNonNull(adjustPoints, "adjustPoints must not be null");
            return this;
        }

        @Override
        public _FinalStage allowNegativeBalance(Nullable<Boolean> allowNegativeBalance) {
            this.allowNegativeBalance = allowNegativeBalance.isNull() ? null : (allowNegativeBalance.isEmpty() ? Optional.empty() : Optional.of(allowNegativeBalance.get()));
            return this;
        }

        @Override
        public _FinalStage allowNegativeBalance(Boolean allowNegativeBalance) {
            this.allowNegativeBalance = Optional.ofNullable(allowNegativeBalance);
            return this;
        }

        @Override
        @JsonSetter(value="allow_negative_balance", nulls=Nulls.SKIP)
        public _FinalStage allowNegativeBalance(Optional<Boolean> allowNegativeBalance) {
            this.allowNegativeBalance = allowNegativeBalance;
            return this;
        }

        @Override
        public AdjustLoyaltyPointsRequest build() {
            return new AdjustLoyaltyPointsRequest(this.accountId, this.idempotencyKey, this.adjustPoints, this.allowNegativeBalance, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public AdjustLoyaltyPointsRequest build();

        public _FinalStage allowNegativeBalance(Optional<Boolean> var1);

        public _FinalStage allowNegativeBalance(Boolean var1);

        public _FinalStage allowNegativeBalance(Nullable<Boolean> var1);
    }

    public static interface AdjustPointsStage {
        public _FinalStage adjustPoints(@NotNull LoyaltyEventAdjustPoints var1);
    }

    public static interface IdempotencyKeyStage {
        public AdjustPointsStage idempotencyKey(@NotNull String var1);
    }

    public static interface AccountIdStage {
        public IdempotencyKeyStage accountId(@NotNull String var1);

        public Builder from(AdjustLoyaltyPointsRequest var1);
    }
}

