/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.loyalty.programs.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class GetPromotionsRequest {
    private final String promotionId;
    private final String programId;
    private final Map<String, Object> additionalProperties;

    private GetPromotionsRequest(String promotionId, String programId, Map<String, Object> additionalProperties) {
        this.promotionId = promotionId;
        this.programId = programId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="promotion_id")
    public String getPromotionId() {
        return this.promotionId;
    }

    @JsonProperty(value="program_id")
    public String getProgramId() {
        return this.programId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof GetPromotionsRequest && this.equalTo((GetPromotionsRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(GetPromotionsRequest other) {
        return this.promotionId.equals(other.promotionId) && this.programId.equals(other.programId);
    }

    public int hashCode() {
        return Objects.hash(this.promotionId, this.programId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static PromotionIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements PromotionIdStage,
    ProgramIdStage,
    _FinalStage {
        private String promotionId;
        private String programId;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(GetPromotionsRequest other) {
            this.promotionId(other.getPromotionId());
            this.programId(other.getProgramId());
            return this;
        }

        @Override
        @JsonSetter(value="promotion_id")
        public ProgramIdStage promotionId(@NotNull String promotionId) {
            this.promotionId = Objects.requireNonNull(promotionId, "promotionId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="program_id")
        public _FinalStage programId(@NotNull String programId) {
            this.programId = Objects.requireNonNull(programId, "programId must not be null");
            return this;
        }

        @Override
        public GetPromotionsRequest build() {
            return new GetPromotionsRequest(this.promotionId, this.programId, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public GetPromotionsRequest build();
    }

    public static interface ProgramIdStage {
        public _FinalStage programId(@NotNull String var1);
    }

    public static interface PromotionIdStage {
        public ProgramIdStage promotionId(@NotNull String var1);

        public Builder from(GetPromotionsRequest var1);
    }
}

