/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.loyalty.programs.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.LoyaltyPromotion;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CreateLoyaltyPromotionRequest {
    private final String programId;
    private final LoyaltyPromotion loyaltyPromotion;
    private final String idempotencyKey;
    private final Map<String, Object> additionalProperties;

    private CreateLoyaltyPromotionRequest(String programId, LoyaltyPromotion loyaltyPromotion, String idempotencyKey, Map<String, Object> additionalProperties) {
        this.programId = programId;
        this.loyaltyPromotion = loyaltyPromotion;
        this.idempotencyKey = idempotencyKey;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="program_id")
    public String getProgramId() {
        return this.programId;
    }

    @JsonProperty(value="loyalty_promotion")
    public LoyaltyPromotion getLoyaltyPromotion() {
        return this.loyaltyPromotion;
    }

    @JsonProperty(value="idempotency_key")
    public String getIdempotencyKey() {
        return this.idempotencyKey;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CreateLoyaltyPromotionRequest && this.equalTo((CreateLoyaltyPromotionRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateLoyaltyPromotionRequest other) {
        return this.programId.equals(other.programId) && this.loyaltyPromotion.equals(other.loyaltyPromotion) && this.idempotencyKey.equals(other.idempotencyKey);
    }

    public int hashCode() {
        return Objects.hash(this.programId, this.loyaltyPromotion, this.idempotencyKey);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ProgramIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements ProgramIdStage,
    LoyaltyPromotionStage,
    IdempotencyKeyStage,
    _FinalStage {
        private String programId;
        private LoyaltyPromotion loyaltyPromotion;
        private String idempotencyKey;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CreateLoyaltyPromotionRequest other) {
            this.programId(other.getProgramId());
            this.loyaltyPromotion(other.getLoyaltyPromotion());
            this.idempotencyKey(other.getIdempotencyKey());
            return this;
        }

        @Override
        @JsonSetter(value="program_id")
        public LoyaltyPromotionStage programId(@NotNull String programId) {
            this.programId = Objects.requireNonNull(programId, "programId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="loyalty_promotion")
        public IdempotencyKeyStage loyaltyPromotion(@NotNull LoyaltyPromotion loyaltyPromotion) {
            this.loyaltyPromotion = Objects.requireNonNull(loyaltyPromotion, "loyaltyPromotion must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="idempotency_key")
        public _FinalStage idempotencyKey(@NotNull String idempotencyKey) {
            this.idempotencyKey = Objects.requireNonNull(idempotencyKey, "idempotencyKey must not be null");
            return this;
        }

        @Override
        public CreateLoyaltyPromotionRequest build() {
            return new CreateLoyaltyPromotionRequest(this.programId, this.loyaltyPromotion, this.idempotencyKey, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CreateLoyaltyPromotionRequest build();
    }

    public static interface IdempotencyKeyStage {
        public _FinalStage idempotencyKey(@NotNull String var1);
    }

    public static interface LoyaltyPromotionStage {
        public IdempotencyKeyStage loyaltyPromotion(@NotNull LoyaltyPromotion var1);
    }

    public static interface ProgramIdStage {
        public LoyaltyPromotionStage programId(@NotNull String var1);

        public Builder from(CreateLoyaltyPromotionRequest var1);
    }
}

