/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.loyalty;

import com.squareup.square.core.ClientOptions;
import com.squareup.square.core.RequestOptions;
import com.squareup.square.core.Suppliers;
import com.squareup.square.loyalty.RawProgramsClient;
import com.squareup.square.loyalty.programs.PromotionsClient;
import com.squareup.square.loyalty.types.CalculateLoyaltyPointsRequest;
import com.squareup.square.loyalty.types.GetProgramsRequest;
import com.squareup.square.types.CalculateLoyaltyPointsResponse;
import com.squareup.square.types.GetLoyaltyProgramResponse;
import com.squareup.square.types.ListLoyaltyProgramsResponse;
import java.util.function.Supplier;

public class ProgramsClient {
    protected final ClientOptions clientOptions;
    private final RawProgramsClient rawClient;
    protected final Supplier<PromotionsClient> promotionsClient;

    public ProgramsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawProgramsClient(clientOptions);
        this.promotionsClient = Suppliers.memoize(() -> new PromotionsClient(clientOptions));
    }

    public RawProgramsClient withRawResponse() {
        return this.rawClient;
    }

    public ListLoyaltyProgramsResponse list() {
        return this.rawClient.list().body();
    }

    public ListLoyaltyProgramsResponse list(RequestOptions requestOptions) {
        return this.rawClient.list(requestOptions).body();
    }

    public GetLoyaltyProgramResponse get(GetProgramsRequest request) {
        return this.rawClient.get(request).body();
    }

    public GetLoyaltyProgramResponse get(GetProgramsRequest request, RequestOptions requestOptions) {
        return this.rawClient.get(request, requestOptions).body();
    }

    public CalculateLoyaltyPointsResponse calculate(CalculateLoyaltyPointsRequest request) {
        return this.rawClient.calculate(request).body();
    }

    public CalculateLoyaltyPointsResponse calculate(CalculateLoyaltyPointsRequest request, RequestOptions requestOptions) {
        return this.rawClient.calculate(request, requestOptions).body();
    }

    public PromotionsClient promotions() {
        return this.promotionsClient.get();
    }
}

