/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.loyalty;

import com.squareup.square.core.ClientOptions;
import com.squareup.square.core.RequestOptions;
import com.squareup.square.loyalty.AsyncRawRewardsClient;
import com.squareup.square.loyalty.types.CreateLoyaltyRewardRequest;
import com.squareup.square.loyalty.types.DeleteRewardsRequest;
import com.squareup.square.loyalty.types.GetRewardsRequest;
import com.squareup.square.loyalty.types.RedeemLoyaltyRewardRequest;
import com.squareup.square.loyalty.types.SearchLoyaltyRewardsRequest;
import com.squareup.square.types.CreateLoyaltyRewardResponse;
import com.squareup.square.types.DeleteLoyaltyRewardResponse;
import com.squareup.square.types.GetLoyaltyRewardResponse;
import com.squareup.square.types.RedeemLoyaltyRewardResponse;
import com.squareup.square.types.SearchLoyaltyRewardsResponse;
import java.util.concurrent.CompletableFuture;

public class AsyncRewardsClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawRewardsClient rawClient;

    public AsyncRewardsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawRewardsClient(clientOptions);
    }

    public AsyncRawRewardsClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<CreateLoyaltyRewardResponse> create(CreateLoyaltyRewardRequest request) {
        return this.rawClient.create(request).thenApply(response -> (CreateLoyaltyRewardResponse)response.body());
    }

    public CompletableFuture<CreateLoyaltyRewardResponse> create(CreateLoyaltyRewardRequest request, RequestOptions requestOptions) {
        return this.rawClient.create(request, requestOptions).thenApply(response -> (CreateLoyaltyRewardResponse)response.body());
    }

    public CompletableFuture<SearchLoyaltyRewardsResponse> search() {
        return this.rawClient.search().thenApply(response -> (SearchLoyaltyRewardsResponse)response.body());
    }

    public CompletableFuture<SearchLoyaltyRewardsResponse> search(SearchLoyaltyRewardsRequest request) {
        return this.rawClient.search(request).thenApply(response -> (SearchLoyaltyRewardsResponse)response.body());
    }

    public CompletableFuture<SearchLoyaltyRewardsResponse> search(SearchLoyaltyRewardsRequest request, RequestOptions requestOptions) {
        return this.rawClient.search(request, requestOptions).thenApply(response -> (SearchLoyaltyRewardsResponse)response.body());
    }

    public CompletableFuture<GetLoyaltyRewardResponse> get(GetRewardsRequest request) {
        return this.rawClient.get(request).thenApply(response -> (GetLoyaltyRewardResponse)response.body());
    }

    public CompletableFuture<GetLoyaltyRewardResponse> get(GetRewardsRequest request, RequestOptions requestOptions) {
        return this.rawClient.get(request, requestOptions).thenApply(response -> (GetLoyaltyRewardResponse)response.body());
    }

    public CompletableFuture<DeleteLoyaltyRewardResponse> delete(DeleteRewardsRequest request) {
        return this.rawClient.delete(request).thenApply(response -> (DeleteLoyaltyRewardResponse)response.body());
    }

    public CompletableFuture<DeleteLoyaltyRewardResponse> delete(DeleteRewardsRequest request, RequestOptions requestOptions) {
        return this.rawClient.delete(request, requestOptions).thenApply(response -> (DeleteLoyaltyRewardResponse)response.body());
    }

    public CompletableFuture<RedeemLoyaltyRewardResponse> redeem(RedeemLoyaltyRewardRequest request) {
        return this.rawClient.redeem(request).thenApply(response -> (RedeemLoyaltyRewardResponse)response.body());
    }

    public CompletableFuture<RedeemLoyaltyRewardResponse> redeem(RedeemLoyaltyRewardRequest request, RequestOptions requestOptions) {
        return this.rawClient.redeem(request, requestOptions).thenApply(response -> (RedeemLoyaltyRewardResponse)response.body());
    }
}

