/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.loyalty;

import com.squareup.square.core.ClientOptions;
import com.squareup.square.core.RequestOptions;
import com.squareup.square.loyalty.AsyncRawAccountsClient;
import com.squareup.square.loyalty.types.AccumulateLoyaltyPointsRequest;
import com.squareup.square.loyalty.types.AdjustLoyaltyPointsRequest;
import com.squareup.square.loyalty.types.CreateLoyaltyAccountRequest;
import com.squareup.square.loyalty.types.GetAccountsRequest;
import com.squareup.square.loyalty.types.SearchLoyaltyAccountsRequest;
import com.squareup.square.types.AccumulateLoyaltyPointsResponse;
import com.squareup.square.types.AdjustLoyaltyPointsResponse;
import com.squareup.square.types.CreateLoyaltyAccountResponse;
import com.squareup.square.types.GetLoyaltyAccountResponse;
import com.squareup.square.types.SearchLoyaltyAccountsResponse;
import java.util.concurrent.CompletableFuture;

public class AsyncAccountsClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawAccountsClient rawClient;

    public AsyncAccountsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawAccountsClient(clientOptions);
    }

    public AsyncRawAccountsClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<CreateLoyaltyAccountResponse> create(CreateLoyaltyAccountRequest request) {
        return this.rawClient.create(request).thenApply(response -> (CreateLoyaltyAccountResponse)response.body());
    }

    public CompletableFuture<CreateLoyaltyAccountResponse> create(CreateLoyaltyAccountRequest request, RequestOptions requestOptions) {
        return this.rawClient.create(request, requestOptions).thenApply(response -> (CreateLoyaltyAccountResponse)response.body());
    }

    public CompletableFuture<SearchLoyaltyAccountsResponse> search() {
        return this.rawClient.search().thenApply(response -> (SearchLoyaltyAccountsResponse)response.body());
    }

    public CompletableFuture<SearchLoyaltyAccountsResponse> search(SearchLoyaltyAccountsRequest request) {
        return this.rawClient.search(request).thenApply(response -> (SearchLoyaltyAccountsResponse)response.body());
    }

    public CompletableFuture<SearchLoyaltyAccountsResponse> search(SearchLoyaltyAccountsRequest request, RequestOptions requestOptions) {
        return this.rawClient.search(request, requestOptions).thenApply(response -> (SearchLoyaltyAccountsResponse)response.body());
    }

    public CompletableFuture<GetLoyaltyAccountResponse> get(GetAccountsRequest request) {
        return this.rawClient.get(request).thenApply(response -> (GetLoyaltyAccountResponse)response.body());
    }

    public CompletableFuture<GetLoyaltyAccountResponse> get(GetAccountsRequest request, RequestOptions requestOptions) {
        return this.rawClient.get(request, requestOptions).thenApply(response -> (GetLoyaltyAccountResponse)response.body());
    }

    public CompletableFuture<AccumulateLoyaltyPointsResponse> accumulatePoints(AccumulateLoyaltyPointsRequest request) {
        return this.rawClient.accumulatePoints(request).thenApply(response -> (AccumulateLoyaltyPointsResponse)response.body());
    }

    public CompletableFuture<AccumulateLoyaltyPointsResponse> accumulatePoints(AccumulateLoyaltyPointsRequest request, RequestOptions requestOptions) {
        return this.rawClient.accumulatePoints(request, requestOptions).thenApply(response -> (AccumulateLoyaltyPointsResponse)response.body());
    }

    public CompletableFuture<AdjustLoyaltyPointsResponse> adjust(AdjustLoyaltyPointsRequest request) {
        return this.rawClient.adjust(request).thenApply(response -> (AdjustLoyaltyPointsResponse)response.body());
    }

    public CompletableFuture<AdjustLoyaltyPointsResponse> adjust(AdjustLoyaltyPointsRequest request, RequestOptions requestOptions) {
        return this.rawClient.adjust(request, requestOptions).thenApply(response -> (AdjustLoyaltyPointsResponse)response.body());
    }
}

