/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.locations.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.VisibilityFilter;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ListCustomAttributesRequest {
    private final String locationId;
    private final Optional<VisibilityFilter> visibilityFilter;
    private final Optional<Integer> limit;
    private final Optional<String> cursor;
    private final Optional<Boolean> withDefinitions;
    private final Map<String, Object> additionalProperties;

    private ListCustomAttributesRequest(String locationId, Optional<VisibilityFilter> visibilityFilter, Optional<Integer> limit, Optional<String> cursor, Optional<Boolean> withDefinitions, Map<String, Object> additionalProperties) {
        this.locationId = locationId;
        this.visibilityFilter = visibilityFilter;
        this.limit = limit;
        this.cursor = cursor;
        this.withDefinitions = withDefinitions;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="location_id")
    public String getLocationId() {
        return this.locationId;
    }

    @JsonIgnore
    public Optional<VisibilityFilter> getVisibilityFilter() {
        if (this.visibilityFilter == null) {
            return Optional.empty();
        }
        return this.visibilityFilter;
    }

    @JsonIgnore
    public Optional<Integer> getLimit() {
        if (this.limit == null) {
            return Optional.empty();
        }
        return this.limit;
    }

    @JsonIgnore
    public Optional<String> getCursor() {
        if (this.cursor == null) {
            return Optional.empty();
        }
        return this.cursor;
    }

    @JsonIgnore
    public Optional<Boolean> getWithDefinitions() {
        if (this.withDefinitions == null) {
            return Optional.empty();
        }
        return this.withDefinitions;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="visibility_filter")
    private Optional<VisibilityFilter> _getVisibilityFilter() {
        return this.visibilityFilter;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="limit")
    private Optional<Integer> _getLimit() {
        return this.limit;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="cursor")
    private Optional<String> _getCursor() {
        return this.cursor;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="with_definitions")
    private Optional<Boolean> _getWithDefinitions() {
        return this.withDefinitions;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ListCustomAttributesRequest && this.equalTo((ListCustomAttributesRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ListCustomAttributesRequest other) {
        return this.locationId.equals(other.locationId) && this.visibilityFilter.equals(other.visibilityFilter) && this.limit.equals(other.limit) && this.cursor.equals(other.cursor) && this.withDefinitions.equals(other.withDefinitions);
    }

    public int hashCode() {
        return Objects.hash(this.locationId, this.visibilityFilter, this.limit, this.cursor, this.withDefinitions);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static LocationIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements LocationIdStage,
    _FinalStage {
        private String locationId;
        private Optional<Boolean> withDefinitions = Optional.empty();
        private Optional<String> cursor = Optional.empty();
        private Optional<Integer> limit = Optional.empty();
        private Optional<VisibilityFilter> visibilityFilter = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(ListCustomAttributesRequest other) {
            this.locationId(other.getLocationId());
            this.visibilityFilter(other.getVisibilityFilter());
            this.limit(other.getLimit());
            this.cursor(other.getCursor());
            this.withDefinitions(other.getWithDefinitions());
            return this;
        }

        @Override
        @JsonSetter(value="location_id")
        public _FinalStage locationId(@NotNull String locationId) {
            this.locationId = Objects.requireNonNull(locationId, "locationId must not be null");
            return this;
        }

        @Override
        public _FinalStage withDefinitions(Nullable<Boolean> withDefinitions) {
            this.withDefinitions = withDefinitions.isNull() ? null : (withDefinitions.isEmpty() ? Optional.empty() : Optional.of(withDefinitions.get()));
            return this;
        }

        @Override
        public _FinalStage withDefinitions(Boolean withDefinitions) {
            this.withDefinitions = Optional.ofNullable(withDefinitions);
            return this;
        }

        @Override
        @JsonSetter(value="with_definitions", nulls=Nulls.SKIP)
        public _FinalStage withDefinitions(Optional<Boolean> withDefinitions) {
            this.withDefinitions = withDefinitions;
            return this;
        }

        @Override
        public _FinalStage cursor(Nullable<String> cursor) {
            this.cursor = cursor.isNull() ? null : (cursor.isEmpty() ? Optional.empty() : Optional.of(cursor.get()));
            return this;
        }

        @Override
        public _FinalStage cursor(String cursor) {
            this.cursor = Optional.ofNullable(cursor);
            return this;
        }

        @Override
        @JsonSetter(value="cursor", nulls=Nulls.SKIP)
        public _FinalStage cursor(Optional<String> cursor) {
            this.cursor = cursor;
            return this;
        }

        @Override
        public _FinalStage limit(Nullable<Integer> limit) {
            this.limit = limit.isNull() ? null : (limit.isEmpty() ? Optional.empty() : Optional.of(limit.get()));
            return this;
        }

        @Override
        public _FinalStage limit(Integer limit) {
            this.limit = Optional.ofNullable(limit);
            return this;
        }

        @Override
        @JsonSetter(value="limit", nulls=Nulls.SKIP)
        public _FinalStage limit(Optional<Integer> limit) {
            this.limit = limit;
            return this;
        }

        @Override
        public _FinalStage visibilityFilter(Nullable<VisibilityFilter> visibilityFilter) {
            this.visibilityFilter = visibilityFilter.isNull() ? null : (visibilityFilter.isEmpty() ? Optional.empty() : Optional.of(visibilityFilter.get()));
            return this;
        }

        @Override
        public _FinalStage visibilityFilter(VisibilityFilter visibilityFilter) {
            this.visibilityFilter = Optional.ofNullable(visibilityFilter);
            return this;
        }

        @Override
        @JsonSetter(value="visibility_filter", nulls=Nulls.SKIP)
        public _FinalStage visibilityFilter(Optional<VisibilityFilter> visibilityFilter) {
            this.visibilityFilter = visibilityFilter;
            return this;
        }

        @Override
        public ListCustomAttributesRequest build() {
            return new ListCustomAttributesRequest(this.locationId, this.visibilityFilter, this.limit, this.cursor, this.withDefinitions, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public ListCustomAttributesRequest build();

        public _FinalStage visibilityFilter(Optional<VisibilityFilter> var1);

        public _FinalStage visibilityFilter(VisibilityFilter var1);

        public _FinalStage visibilityFilter(Nullable<VisibilityFilter> var1);

        public _FinalStage limit(Optional<Integer> var1);

        public _FinalStage limit(Integer var1);

        public _FinalStage limit(Nullable<Integer> var1);

        public _FinalStage cursor(Optional<String> var1);

        public _FinalStage cursor(String var1);

        public _FinalStage cursor(Nullable<String> var1);

        public _FinalStage withDefinitions(Optional<Boolean> var1);

        public _FinalStage withDefinitions(Boolean var1);

        public _FinalStage withDefinitions(Nullable<Boolean> var1);
    }

    public static interface LocationIdStage {
        public _FinalStage locationId(@NotNull String var1);

        public Builder from(ListCustomAttributesRequest var1);
    }
}

