/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.locations.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class DeleteCustomAttributesRequest {
    private final String locationId;
    private final String key;
    private final Map<String, Object> additionalProperties;

    private DeleteCustomAttributesRequest(String locationId, String key, Map<String, Object> additionalProperties) {
        this.locationId = locationId;
        this.key = key;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="location_id")
    public String getLocationId() {
        return this.locationId;
    }

    @JsonProperty(value="key")
    public String getKey() {
        return this.key;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof DeleteCustomAttributesRequest && this.equalTo((DeleteCustomAttributesRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(DeleteCustomAttributesRequest other) {
        return this.locationId.equals(other.locationId) && this.key.equals(other.key);
    }

    public int hashCode() {
        return Objects.hash(this.locationId, this.key);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static LocationIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements LocationIdStage,
    KeyStage,
    _FinalStage {
        private String locationId;
        private String key;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(DeleteCustomAttributesRequest other) {
            this.locationId(other.getLocationId());
            this.key(other.getKey());
            return this;
        }

        @Override
        @JsonSetter(value="location_id")
        public KeyStage locationId(@NotNull String locationId) {
            this.locationId = Objects.requireNonNull(locationId, "locationId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="key")
        public _FinalStage key(@NotNull String key) {
            this.key = Objects.requireNonNull(key, "key must not be null");
            return this;
        }

        @Override
        public DeleteCustomAttributesRequest build() {
            return new DeleteCustomAttributesRequest(this.locationId, this.key, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public DeleteCustomAttributesRequest build();
    }

    public static interface KeyStage {
        public _FinalStage key(@NotNull String var1);
    }

    public static interface LocationIdStage {
        public KeyStage locationId(@NotNull String var1);

        public Builder from(DeleteCustomAttributesRequest var1);
    }
}

