/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.locations;

import com.squareup.square.core.ClientOptions;
import com.squareup.square.core.RequestOptions;
import com.squareup.square.core.SyncPagingIterable;
import com.squareup.square.locations.AsyncRawCustomAttributesClient;
import com.squareup.square.locations.types.BulkDeleteLocationCustomAttributesRequest;
import com.squareup.square.locations.types.BulkUpsertLocationCustomAttributesRequest;
import com.squareup.square.locations.types.DeleteCustomAttributesRequest;
import com.squareup.square.locations.types.GetCustomAttributesRequest;
import com.squareup.square.locations.types.ListCustomAttributesRequest;
import com.squareup.square.locations.types.UpsertLocationCustomAttributeRequest;
import com.squareup.square.types.BulkDeleteLocationCustomAttributesResponse;
import com.squareup.square.types.BulkUpsertLocationCustomAttributesResponse;
import com.squareup.square.types.CustomAttribute;
import com.squareup.square.types.DeleteLocationCustomAttributeResponse;
import com.squareup.square.types.RetrieveLocationCustomAttributeResponse;
import com.squareup.square.types.UpsertLocationCustomAttributeResponse;
import java.util.concurrent.CompletableFuture;

public class AsyncCustomAttributesClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawCustomAttributesClient rawClient;

    public AsyncCustomAttributesClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawCustomAttributesClient(clientOptions);
    }

    public AsyncRawCustomAttributesClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<BulkDeleteLocationCustomAttributesResponse> batchDelete(BulkDeleteLocationCustomAttributesRequest request) {
        return this.rawClient.batchDelete(request).thenApply(response -> (BulkDeleteLocationCustomAttributesResponse)response.body());
    }

    public CompletableFuture<BulkDeleteLocationCustomAttributesResponse> batchDelete(BulkDeleteLocationCustomAttributesRequest request, RequestOptions requestOptions) {
        return this.rawClient.batchDelete(request, requestOptions).thenApply(response -> (BulkDeleteLocationCustomAttributesResponse)response.body());
    }

    public CompletableFuture<BulkUpsertLocationCustomAttributesResponse> batchUpsert(BulkUpsertLocationCustomAttributesRequest request) {
        return this.rawClient.batchUpsert(request).thenApply(response -> (BulkUpsertLocationCustomAttributesResponse)response.body());
    }

    public CompletableFuture<BulkUpsertLocationCustomAttributesResponse> batchUpsert(BulkUpsertLocationCustomAttributesRequest request, RequestOptions requestOptions) {
        return this.rawClient.batchUpsert(request, requestOptions).thenApply(response -> (BulkUpsertLocationCustomAttributesResponse)response.body());
    }

    public CompletableFuture<SyncPagingIterable<CustomAttribute>> list(ListCustomAttributesRequest request) {
        return this.rawClient.list(request).thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<SyncPagingIterable<CustomAttribute>> list(ListCustomAttributesRequest request, RequestOptions requestOptions) {
        return this.rawClient.list(request, requestOptions).thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<RetrieveLocationCustomAttributeResponse> get(GetCustomAttributesRequest request) {
        return this.rawClient.get(request).thenApply(response -> (RetrieveLocationCustomAttributeResponse)response.body());
    }

    public CompletableFuture<RetrieveLocationCustomAttributeResponse> get(GetCustomAttributesRequest request, RequestOptions requestOptions) {
        return this.rawClient.get(request, requestOptions).thenApply(response -> (RetrieveLocationCustomAttributeResponse)response.body());
    }

    public CompletableFuture<UpsertLocationCustomAttributeResponse> upsert(UpsertLocationCustomAttributeRequest request) {
        return this.rawClient.upsert(request).thenApply(response -> (UpsertLocationCustomAttributeResponse)response.body());
    }

    public CompletableFuture<UpsertLocationCustomAttributeResponse> upsert(UpsertLocationCustomAttributeRequest request, RequestOptions requestOptions) {
        return this.rawClient.upsert(request, requestOptions).thenApply(response -> (UpsertLocationCustomAttributeResponse)response.body());
    }

    public CompletableFuture<DeleteLocationCustomAttributeResponse> delete(DeleteCustomAttributesRequest request) {
        return this.rawClient.delete(request).thenApply(response -> (DeleteLocationCustomAttributeResponse)response.body());
    }

    public CompletableFuture<DeleteLocationCustomAttributeResponse> delete(DeleteCustomAttributesRequest request, RequestOptions requestOptions) {
        return this.rawClient.delete(request, requestOptions).thenApply(response -> (DeleteLocationCustomAttributeResponse)response.body());
    }
}

