/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.labor.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.BreakType;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class UpdateBreakTypeRequest {
    private final String id;
    private final BreakType breakType;
    private final Map<String, Object> additionalProperties;

    private UpdateBreakTypeRequest(String id, BreakType breakType, Map<String, Object> additionalProperties) {
        this.id = id;
        this.breakType = breakType;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="break_type")
    public BreakType getBreakType() {
        return this.breakType;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof UpdateBreakTypeRequest && this.equalTo((UpdateBreakTypeRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(UpdateBreakTypeRequest other) {
        return this.id.equals(other.id) && this.breakType.equals(other.breakType);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.breakType);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdStage,
    BreakTypeStage,
    _FinalStage {
        private String id;
        private BreakType breakType;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(UpdateBreakTypeRequest other) {
            this.id(other.getId());
            this.breakType(other.getBreakType());
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public BreakTypeStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="break_type")
        public _FinalStage breakType(@NotNull BreakType breakType) {
            this.breakType = Objects.requireNonNull(breakType, "breakType must not be null");
            return this;
        }

        @Override
        public UpdateBreakTypeRequest build() {
            return new UpdateBreakTypeRequest(this.id, this.breakType, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public UpdateBreakTypeRequest build();
    }

    public static interface BreakTypeStage {
        public _FinalStage breakType(@NotNull BreakType var1);
    }

    public static interface IdStage {
        public BreakTypeStage id(@NotNull String var1);

        public Builder from(UpdateBreakTypeRequest var1);
    }
}

