/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.labor.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Shift;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CreateShiftRequest {
    private final Optional<String> idempotencyKey;
    private final Shift shift;
    private final Map<String, Object> additionalProperties;

    private CreateShiftRequest(Optional<String> idempotencyKey, Shift shift, Map<String, Object> additionalProperties) {
        this.idempotencyKey = idempotencyKey;
        this.shift = shift;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="idempotency_key")
    public Optional<String> getIdempotencyKey() {
        return this.idempotencyKey;
    }

    @JsonProperty(value="shift")
    public Shift getShift() {
        return this.shift;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CreateShiftRequest && this.equalTo((CreateShiftRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateShiftRequest other) {
        return this.idempotencyKey.equals(other.idempotencyKey) && this.shift.equals(other.shift);
    }

    public int hashCode() {
        return Objects.hash(this.idempotencyKey, this.shift);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ShiftStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements ShiftStage,
    _FinalStage {
        private Shift shift;
        private Optional<String> idempotencyKey = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CreateShiftRequest other) {
            this.idempotencyKey(other.getIdempotencyKey());
            this.shift(other.getShift());
            return this;
        }

        @Override
        @JsonSetter(value="shift")
        public _FinalStage shift(@NotNull Shift shift) {
            this.shift = Objects.requireNonNull(shift, "shift must not be null");
            return this;
        }

        @Override
        public _FinalStage idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = Optional.ofNullable(idempotencyKey);
            return this;
        }

        @Override
        @JsonSetter(value="idempotency_key", nulls=Nulls.SKIP)
        public _FinalStage idempotencyKey(Optional<String> idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        @Override
        public CreateShiftRequest build() {
            return new CreateShiftRequest(this.idempotencyKey, this.shift, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CreateShiftRequest build();

        public _FinalStage idempotencyKey(Optional<String> var1);

        public _FinalStage idempotencyKey(String var1);
    }

    public static interface ShiftStage {
        public _FinalStage shift(@NotNull Shift var1);

        public Builder from(CreateShiftRequest var1);
    }
}

