/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.labor;

import com.squareup.square.core.ClientOptions;
import com.squareup.square.core.RequestOptions;
import com.squareup.square.core.SyncPagingIterable;
import com.squareup.square.labor.AsyncRawEmployeeWagesClient;
import com.squareup.square.labor.types.GetEmployeeWagesRequest;
import com.squareup.square.labor.types.ListEmployeeWagesRequest;
import com.squareup.square.types.EmployeeWage;
import com.squareup.square.types.GetEmployeeWageResponse;
import java.util.concurrent.CompletableFuture;

public class AsyncEmployeeWagesClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawEmployeeWagesClient rawClient;

    public AsyncEmployeeWagesClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawEmployeeWagesClient(clientOptions);
    }

    public AsyncRawEmployeeWagesClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<SyncPagingIterable<EmployeeWage>> list() {
        return this.rawClient.list().thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<SyncPagingIterable<EmployeeWage>> list(ListEmployeeWagesRequest request) {
        return this.rawClient.list(request).thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<SyncPagingIterable<EmployeeWage>> list(ListEmployeeWagesRequest request, RequestOptions requestOptions) {
        return this.rawClient.list(request, requestOptions).thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<GetEmployeeWageResponse> get(GetEmployeeWagesRequest request) {
        return this.rawClient.get(request).thenApply(response -> (GetEmployeeWageResponse)response.body());
    }

    public CompletableFuture<GetEmployeeWageResponse> get(GetEmployeeWagesRequest request, RequestOptions requestOptions) {
        return this.rawClient.get(request, requestOptions).thenApply(response -> (GetEmployeeWageResponse)response.body());
    }
}

