/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.giftcards.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ListActivitiesRequest {
    private final Optional<String> giftCardId;
    private final Optional<String> type;
    private final Optional<String> locationId;
    private final Optional<String> beginTime;
    private final Optional<String> endTime;
    private final Optional<Integer> limit;
    private final Optional<String> cursor;
    private final Optional<String> sortOrder;
    private final Map<String, Object> additionalProperties;

    private ListActivitiesRequest(Optional<String> giftCardId, Optional<String> type, Optional<String> locationId, Optional<String> beginTime, Optional<String> endTime, Optional<Integer> limit, Optional<String> cursor, Optional<String> sortOrder, Map<String, Object> additionalProperties) {
        this.giftCardId = giftCardId;
        this.type = type;
        this.locationId = locationId;
        this.beginTime = beginTime;
        this.endTime = endTime;
        this.limit = limit;
        this.cursor = cursor;
        this.sortOrder = sortOrder;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<String> getGiftCardId() {
        if (this.giftCardId == null) {
            return Optional.empty();
        }
        return this.giftCardId;
    }

    @JsonIgnore
    public Optional<String> getType() {
        if (this.type == null) {
            return Optional.empty();
        }
        return this.type;
    }

    @JsonIgnore
    public Optional<String> getLocationId() {
        if (this.locationId == null) {
            return Optional.empty();
        }
        return this.locationId;
    }

    @JsonIgnore
    public Optional<String> getBeginTime() {
        if (this.beginTime == null) {
            return Optional.empty();
        }
        return this.beginTime;
    }

    @JsonIgnore
    public Optional<String> getEndTime() {
        if (this.endTime == null) {
            return Optional.empty();
        }
        return this.endTime;
    }

    @JsonIgnore
    public Optional<Integer> getLimit() {
        if (this.limit == null) {
            return Optional.empty();
        }
        return this.limit;
    }

    @JsonIgnore
    public Optional<String> getCursor() {
        if (this.cursor == null) {
            return Optional.empty();
        }
        return this.cursor;
    }

    @JsonIgnore
    public Optional<String> getSortOrder() {
        if (this.sortOrder == null) {
            return Optional.empty();
        }
        return this.sortOrder;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="gift_card_id")
    private Optional<String> _getGiftCardId() {
        return this.giftCardId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="type")
    private Optional<String> _getType() {
        return this.type;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="location_id")
    private Optional<String> _getLocationId() {
        return this.locationId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="begin_time")
    private Optional<String> _getBeginTime() {
        return this.beginTime;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="end_time")
    private Optional<String> _getEndTime() {
        return this.endTime;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="limit")
    private Optional<Integer> _getLimit() {
        return this.limit;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="cursor")
    private Optional<String> _getCursor() {
        return this.cursor;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="sort_order")
    private Optional<String> _getSortOrder() {
        return this.sortOrder;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ListActivitiesRequest && this.equalTo((ListActivitiesRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ListActivitiesRequest other) {
        return this.giftCardId.equals(other.giftCardId) && this.type.equals(other.type) && this.locationId.equals(other.locationId) && this.beginTime.equals(other.beginTime) && this.endTime.equals(other.endTime) && this.limit.equals(other.limit) && this.cursor.equals(other.cursor) && this.sortOrder.equals(other.sortOrder);
    }

    public int hashCode() {
        return Objects.hash(this.giftCardId, this.type, this.locationId, this.beginTime, this.endTime, this.limit, this.cursor, this.sortOrder);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> giftCardId = Optional.empty();
        private Optional<String> type = Optional.empty();
        private Optional<String> locationId = Optional.empty();
        private Optional<String> beginTime = Optional.empty();
        private Optional<String> endTime = Optional.empty();
        private Optional<Integer> limit = Optional.empty();
        private Optional<String> cursor = Optional.empty();
        private Optional<String> sortOrder = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ListActivitiesRequest other) {
            this.giftCardId(other.getGiftCardId());
            this.type(other.getType());
            this.locationId(other.getLocationId());
            this.beginTime(other.getBeginTime());
            this.endTime(other.getEndTime());
            this.limit(other.getLimit());
            this.cursor(other.getCursor());
            this.sortOrder(other.getSortOrder());
            return this;
        }

        @JsonSetter(value="gift_card_id", nulls=Nulls.SKIP)
        public Builder giftCardId(Optional<String> giftCardId) {
            this.giftCardId = giftCardId;
            return this;
        }

        public Builder giftCardId(String giftCardId) {
            this.giftCardId = Optional.ofNullable(giftCardId);
            return this;
        }

        public Builder giftCardId(Nullable<String> giftCardId) {
            this.giftCardId = giftCardId.isNull() ? null : (giftCardId.isEmpty() ? Optional.empty() : Optional.of(giftCardId.get()));
            return this;
        }

        @JsonSetter(value="type", nulls=Nulls.SKIP)
        public Builder type(Optional<String> type) {
            this.type = type;
            return this;
        }

        public Builder type(String type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        public Builder type(Nullable<String> type) {
            this.type = type.isNull() ? null : (type.isEmpty() ? Optional.empty() : Optional.of(type.get()));
            return this;
        }

        @JsonSetter(value="location_id", nulls=Nulls.SKIP)
        public Builder locationId(Optional<String> locationId) {
            this.locationId = locationId;
            return this;
        }

        public Builder locationId(String locationId) {
            this.locationId = Optional.ofNullable(locationId);
            return this;
        }

        public Builder locationId(Nullable<String> locationId) {
            this.locationId = locationId.isNull() ? null : (locationId.isEmpty() ? Optional.empty() : Optional.of(locationId.get()));
            return this;
        }

        @JsonSetter(value="begin_time", nulls=Nulls.SKIP)
        public Builder beginTime(Optional<String> beginTime) {
            this.beginTime = beginTime;
            return this;
        }

        public Builder beginTime(String beginTime) {
            this.beginTime = Optional.ofNullable(beginTime);
            return this;
        }

        public Builder beginTime(Nullable<String> beginTime) {
            this.beginTime = beginTime.isNull() ? null : (beginTime.isEmpty() ? Optional.empty() : Optional.of(beginTime.get()));
            return this;
        }

        @JsonSetter(value="end_time", nulls=Nulls.SKIP)
        public Builder endTime(Optional<String> endTime) {
            this.endTime = endTime;
            return this;
        }

        public Builder endTime(String endTime) {
            this.endTime = Optional.ofNullable(endTime);
            return this;
        }

        public Builder endTime(Nullable<String> endTime) {
            this.endTime = endTime.isNull() ? null : (endTime.isEmpty() ? Optional.empty() : Optional.of(endTime.get()));
            return this;
        }

        @JsonSetter(value="limit", nulls=Nulls.SKIP)
        public Builder limit(Optional<Integer> limit) {
            this.limit = limit;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = Optional.ofNullable(limit);
            return this;
        }

        public Builder limit(Nullable<Integer> limit) {
            this.limit = limit.isNull() ? null : (limit.isEmpty() ? Optional.empty() : Optional.of(limit.get()));
            return this;
        }

        @JsonSetter(value="cursor", nulls=Nulls.SKIP)
        public Builder cursor(Optional<String> cursor) {
            this.cursor = cursor;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = Optional.ofNullable(cursor);
            return this;
        }

        public Builder cursor(Nullable<String> cursor) {
            this.cursor = cursor.isNull() ? null : (cursor.isEmpty() ? Optional.empty() : Optional.of(cursor.get()));
            return this;
        }

        @JsonSetter(value="sort_order", nulls=Nulls.SKIP)
        public Builder sortOrder(Optional<String> sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortOrder(String sortOrder) {
            this.sortOrder = Optional.ofNullable(sortOrder);
            return this;
        }

        public Builder sortOrder(Nullable<String> sortOrder) {
            this.sortOrder = sortOrder.isNull() ? null : (sortOrder.isEmpty() ? Optional.empty() : Optional.of(sortOrder.get()));
            return this;
        }

        public ListActivitiesRequest build() {
            return new ListActivitiesRequest(this.giftCardId, this.type, this.locationId, this.beginTime, this.endTime, this.limit, this.cursor, this.sortOrder, this.additionalProperties);
        }
    }
}

