/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.giftcards.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.GiftCardActivity;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CreateGiftCardActivityRequest {
    private final String idempotencyKey;
    private final GiftCardActivity giftCardActivity;
    private final Map<String, Object> additionalProperties;

    private CreateGiftCardActivityRequest(String idempotencyKey, GiftCardActivity giftCardActivity, Map<String, Object> additionalProperties) {
        this.idempotencyKey = idempotencyKey;
        this.giftCardActivity = giftCardActivity;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="idempotency_key")
    public String getIdempotencyKey() {
        return this.idempotencyKey;
    }

    @JsonProperty(value="gift_card_activity")
    public GiftCardActivity getGiftCardActivity() {
        return this.giftCardActivity;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CreateGiftCardActivityRequest && this.equalTo((CreateGiftCardActivityRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateGiftCardActivityRequest other) {
        return this.idempotencyKey.equals(other.idempotencyKey) && this.giftCardActivity.equals(other.giftCardActivity);
    }

    public int hashCode() {
        return Objects.hash(this.idempotencyKey, this.giftCardActivity);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdempotencyKeyStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdempotencyKeyStage,
    GiftCardActivityStage,
    _FinalStage {
        private String idempotencyKey;
        private GiftCardActivity giftCardActivity;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CreateGiftCardActivityRequest other) {
            this.idempotencyKey(other.getIdempotencyKey());
            this.giftCardActivity(other.getGiftCardActivity());
            return this;
        }

        @Override
        @JsonSetter(value="idempotency_key")
        public GiftCardActivityStage idempotencyKey(@NotNull String idempotencyKey) {
            this.idempotencyKey = Objects.requireNonNull(idempotencyKey, "idempotencyKey must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="gift_card_activity")
        public _FinalStage giftCardActivity(@NotNull GiftCardActivity giftCardActivity) {
            this.giftCardActivity = Objects.requireNonNull(giftCardActivity, "giftCardActivity must not be null");
            return this;
        }

        @Override
        public CreateGiftCardActivityRequest build() {
            return new CreateGiftCardActivityRequest(this.idempotencyKey, this.giftCardActivity, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CreateGiftCardActivityRequest build();
    }

    public static interface GiftCardActivityStage {
        public _FinalStage giftCardActivity(@NotNull GiftCardActivity var1);
    }

    public static interface IdempotencyKeyStage {
        public GiftCardActivityStage idempotencyKey(@NotNull String var1);

        public Builder from(CreateGiftCardActivityRequest var1);
    }
}

