/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.disputes;

import com.squareup.square.core.ClientOptions;
import com.squareup.square.core.RequestOptions;
import com.squareup.square.core.SyncPagingIterable;
import com.squareup.square.disputes.AsyncRawEvidenceClient;
import com.squareup.square.disputes.types.DeleteEvidenceRequest;
import com.squareup.square.disputes.types.GetEvidenceRequest;
import com.squareup.square.disputes.types.ListEvidenceRequest;
import com.squareup.square.types.DeleteDisputeEvidenceResponse;
import com.squareup.square.types.DisputeEvidence;
import com.squareup.square.types.GetDisputeEvidenceResponse;
import java.util.concurrent.CompletableFuture;

public class AsyncEvidenceClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawEvidenceClient rawClient;

    public AsyncEvidenceClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawEvidenceClient(clientOptions);
    }

    public AsyncRawEvidenceClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<SyncPagingIterable<DisputeEvidence>> list(ListEvidenceRequest request) {
        return this.rawClient.list(request).thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<SyncPagingIterable<DisputeEvidence>> list(ListEvidenceRequest request, RequestOptions requestOptions) {
        return this.rawClient.list(request, requestOptions).thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<GetDisputeEvidenceResponse> get(GetEvidenceRequest request) {
        return this.rawClient.get(request).thenApply(response -> (GetDisputeEvidenceResponse)response.body());
    }

    public CompletableFuture<GetDisputeEvidenceResponse> get(GetEvidenceRequest request, RequestOptions requestOptions) {
        return this.rawClient.get(request, requestOptions).thenApply(response -> (GetDisputeEvidenceResponse)response.body());
    }

    public CompletableFuture<DeleteDisputeEvidenceResponse> delete(DeleteEvidenceRequest request) {
        return this.rawClient.delete(request).thenApply(response -> (DeleteDisputeEvidenceResponse)response.body());
    }

    public CompletableFuture<DeleteDisputeEvidenceResponse> delete(DeleteEvidenceRequest request, RequestOptions requestOptions) {
        return this.rawClient.delete(request, requestOptions).thenApply(response -> (DeleteDisputeEvidenceResponse)response.body());
    }
}

