/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.devices.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.DeviceCode;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CreateDeviceCodeRequest {
    private final String idempotencyKey;
    private final DeviceCode deviceCode;
    private final Map<String, Object> additionalProperties;

    private CreateDeviceCodeRequest(String idempotencyKey, DeviceCode deviceCode, Map<String, Object> additionalProperties) {
        this.idempotencyKey = idempotencyKey;
        this.deviceCode = deviceCode;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="idempotency_key")
    public String getIdempotencyKey() {
        return this.idempotencyKey;
    }

    @JsonProperty(value="device_code")
    public DeviceCode getDeviceCode() {
        return this.deviceCode;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CreateDeviceCodeRequest && this.equalTo((CreateDeviceCodeRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateDeviceCodeRequest other) {
        return this.idempotencyKey.equals(other.idempotencyKey) && this.deviceCode.equals(other.deviceCode);
    }

    public int hashCode() {
        return Objects.hash(this.idempotencyKey, this.deviceCode);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdempotencyKeyStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdempotencyKeyStage,
    DeviceCodeStage,
    _FinalStage {
        private String idempotencyKey;
        private DeviceCode deviceCode;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CreateDeviceCodeRequest other) {
            this.idempotencyKey(other.getIdempotencyKey());
            this.deviceCode(other.getDeviceCode());
            return this;
        }

        @Override
        @JsonSetter(value="idempotency_key")
        public DeviceCodeStage idempotencyKey(@NotNull String idempotencyKey) {
            this.idempotencyKey = Objects.requireNonNull(idempotencyKey, "idempotencyKey must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="device_code")
        public _FinalStage deviceCode(@NotNull DeviceCode deviceCode) {
            this.deviceCode = Objects.requireNonNull(deviceCode, "deviceCode must not be null");
            return this;
        }

        @Override
        public CreateDeviceCodeRequest build() {
            return new CreateDeviceCodeRequest(this.idempotencyKey, this.deviceCode, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CreateDeviceCodeRequest build();
    }

    public static interface DeviceCodeStage {
        public _FinalStage deviceCode(@NotNull DeviceCode var1);
    }

    public static interface IdempotencyKeyStage {
        public DeviceCodeStage idempotencyKey(@NotNull String var1);

        public Builder from(CreateDeviceCodeRequest var1);
    }
}

