/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.devices;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.squareup.square.core.ClientOptions;
import com.squareup.square.core.MediaTypes;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.core.QueryStringMapper;
import com.squareup.square.core.RequestOptions;
import com.squareup.square.core.SquareApiException;
import com.squareup.square.core.SquareClientHttpResponse;
import com.squareup.square.core.SquareException;
import com.squareup.square.core.SyncPagingIterable;
import com.squareup.square.devices.types.CreateDeviceCodeRequest;
import com.squareup.square.devices.types.GetCodesRequest;
import com.squareup.square.devices.types.ListCodesRequest;
import com.squareup.square.types.CreateDeviceCodeResponse;
import com.squareup.square.types.DeviceCode;
import com.squareup.square.types.GetDeviceCodeResponse;
import com.squareup.square.types.ListDeviceCodesResponse;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;

public class AsyncRawCodesClient {
    protected final ClientOptions clientOptions;

    public AsyncRawCodesClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    public CompletableFuture<SquareClientHttpResponse<SyncPagingIterable<DeviceCode>>> list() {
        return this.list(ListCodesRequest.builder().build());
    }

    public CompletableFuture<SquareClientHttpResponse<SyncPagingIterable<DeviceCode>>> list(ListCodesRequest request) {
        return this.list(request, null);
    }

    public CompletableFuture<SquareClientHttpResponse<SyncPagingIterable<DeviceCode>>> list(final ListCodesRequest request, final RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/devices/codes");
        if (request.getCursor().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "cursor", request.getCursor().get(), false);
        }
        if (request.getLocationId().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "location_id", request.getLocationId().get(), false);
        }
        if (request.getProductType().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "product_type", request.getProductType().get(), false);
        }
        if (request.getStatus().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "status", request.getStatus().get(), false);
        }
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        final CompletableFuture<SquareClientHttpResponse<SyncPagingIterable<DeviceCode>>> future = new CompletableFuture<SquareClientHttpResponse<SyncPagingIterable<DeviceCode>>>();
        client.newCall(okhttpRequest).enqueue(new Callback(){

            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body();){
                    if (response.isSuccessful()) {
                        ListDeviceCodesResponse parsedResponse = (ListDeviceCodesResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), ListDeviceCodesResponse.class);
                        Optional<String> startingAfter = parsedResponse.getCursor();
                        ListCodesRequest nextRequest = ListCodesRequest.builder().from(request).cursor(startingAfter).build();
                        List result = parsedResponse.getDeviceCodes().orElse(Collections.emptyList());
                        future.complete(new SquareClientHttpResponse(new SyncPagingIterable(startingAfter.isPresent(), result, () -> {
                            try {
                                return AsyncRawCodesClient.this.list(nextRequest, requestOptions).get().body();
                            }
                            catch (InterruptedException | ExecutionException e) {
                                throw new RuntimeException(e);
                            }
                        }), response));
                        return;
                    }
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    future.completeExceptionally(new SquareApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response));
                    return;
                }
                catch (IOException e) {
                    future.completeExceptionally(new SquareException("Network error executing HTTP request", e));
                    return;
                }
            }

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new SquareException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    public CompletableFuture<SquareClientHttpResponse<CreateDeviceCodeResponse>> create(CreateDeviceCodeRequest request) {
        return this.create(request, null);
    }

    public CompletableFuture<SquareClientHttpResponse<CreateDeviceCodeResponse>> create(CreateDeviceCodeRequest request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/devices/codes").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new SquareException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        final CompletableFuture<SquareClientHttpResponse<CreateDeviceCodeResponse>> future = new CompletableFuture<SquareClientHttpResponse<CreateDeviceCodeResponse>>();
        client.newCall(okhttpRequest).enqueue(new Callback(){

            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body();){
                    if (response.isSuccessful()) {
                        future.complete(new SquareClientHttpResponse<CreateDeviceCodeResponse>((CreateDeviceCodeResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), CreateDeviceCodeResponse.class), response));
                        return;
                    }
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    future.completeExceptionally(new SquareApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response));
                    return;
                }
                catch (IOException e) {
                    future.completeExceptionally(new SquareException("Network error executing HTTP request", e));
                    return;
                }
            }

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new SquareException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    public CompletableFuture<SquareClientHttpResponse<GetDeviceCodeResponse>> get(GetCodesRequest request) {
        return this.get(request, null);
    }

    public CompletableFuture<SquareClientHttpResponse<GetDeviceCodeResponse>> get(GetCodesRequest request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/devices/codes").addPathSegment(request.getId()).build();
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        final CompletableFuture<SquareClientHttpResponse<GetDeviceCodeResponse>> future = new CompletableFuture<SquareClientHttpResponse<GetDeviceCodeResponse>>();
        client.newCall(okhttpRequest).enqueue(new Callback(){

            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body();){
                    if (response.isSuccessful()) {
                        future.complete(new SquareClientHttpResponse<GetDeviceCodeResponse>((GetDeviceCodeResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), GetDeviceCodeResponse.class), response));
                        return;
                    }
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    future.completeExceptionally(new SquareApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response));
                    return;
                }
                catch (IOException e) {
                    future.completeExceptionally(new SquareException("Network error executing HTTP request", e));
                    return;
                }
            }

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new SquareException("Network error executing HTTP request", e));
            }
        });
        return future;
    }
}

