/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.customers.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class RemoveGroupsRequest {
    private final String customerId;
    private final String groupId;
    private final Map<String, Object> additionalProperties;

    private RemoveGroupsRequest(String customerId, String groupId, Map<String, Object> additionalProperties) {
        this.customerId = customerId;
        this.groupId = groupId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="customer_id")
    public String getCustomerId() {
        return this.customerId;
    }

    @JsonProperty(value="group_id")
    public String getGroupId() {
        return this.groupId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof RemoveGroupsRequest && this.equalTo((RemoveGroupsRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(RemoveGroupsRequest other) {
        return this.customerId.equals(other.customerId) && this.groupId.equals(other.groupId);
    }

    public int hashCode() {
        return Objects.hash(this.customerId, this.groupId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CustomerIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements CustomerIdStage,
    GroupIdStage,
    _FinalStage {
        private String customerId;
        private String groupId;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(RemoveGroupsRequest other) {
            this.customerId(other.getCustomerId());
            this.groupId(other.getGroupId());
            return this;
        }

        @Override
        @JsonSetter(value="customer_id")
        public GroupIdStage customerId(@NotNull String customerId) {
            this.customerId = Objects.requireNonNull(customerId, "customerId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="group_id")
        public _FinalStage groupId(@NotNull String groupId) {
            this.groupId = Objects.requireNonNull(groupId, "groupId must not be null");
            return this;
        }

        @Override
        public RemoveGroupsRequest build() {
            return new RemoveGroupsRequest(this.customerId, this.groupId, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public RemoveGroupsRequest build();
    }

    public static interface GroupIdStage {
        public _FinalStage groupId(@NotNull String var1);
    }

    public static interface CustomerIdStage {
        public GroupIdStage customerId(@NotNull String var1);

        public Builder from(RemoveGroupsRequest var1);
    }
}

