/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.customers.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ListCustomAttributeDefinitionsRequest {
    private final Optional<Integer> limit;
    private final Optional<String> cursor;
    private final Map<String, Object> additionalProperties;

    private ListCustomAttributeDefinitionsRequest(Optional<Integer> limit, Optional<String> cursor, Map<String, Object> additionalProperties) {
        this.limit = limit;
        this.cursor = cursor;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<Integer> getLimit() {
        if (this.limit == null) {
            return Optional.empty();
        }
        return this.limit;
    }

    @JsonIgnore
    public Optional<String> getCursor() {
        if (this.cursor == null) {
            return Optional.empty();
        }
        return this.cursor;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="limit")
    private Optional<Integer> _getLimit() {
        return this.limit;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="cursor")
    private Optional<String> _getCursor() {
        return this.cursor;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ListCustomAttributeDefinitionsRequest && this.equalTo((ListCustomAttributeDefinitionsRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ListCustomAttributeDefinitionsRequest other) {
        return this.limit.equals(other.limit) && this.cursor.equals(other.cursor);
    }

    public int hashCode() {
        return Objects.hash(this.limit, this.cursor);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<Integer> limit = Optional.empty();
        private Optional<String> cursor = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ListCustomAttributeDefinitionsRequest other) {
            this.limit(other.getLimit());
            this.cursor(other.getCursor());
            return this;
        }

        @JsonSetter(value="limit", nulls=Nulls.SKIP)
        public Builder limit(Optional<Integer> limit) {
            this.limit = limit;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = Optional.ofNullable(limit);
            return this;
        }

        public Builder limit(Nullable<Integer> limit) {
            this.limit = limit.isNull() ? null : (limit.isEmpty() ? Optional.empty() : Optional.of(limit.get()));
            return this;
        }

        @JsonSetter(value="cursor", nulls=Nulls.SKIP)
        public Builder cursor(Optional<String> cursor) {
            this.cursor = cursor;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = Optional.ofNullable(cursor);
            return this;
        }

        public Builder cursor(Nullable<String> cursor) {
            this.cursor = cursor.isNull() ? null : (cursor.isEmpty() ? Optional.empty() : Optional.of(cursor.get()));
            return this;
        }

        public ListCustomAttributeDefinitionsRequest build() {
            return new ListCustomAttributeDefinitionsRequest(this.limit, this.cursor, this.additionalProperties);
        }
    }
}

