/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.customers;

import com.squareup.square.core.ClientOptions;
import com.squareup.square.core.RequestOptions;
import com.squareup.square.core.SyncPagingIterable;
import com.squareup.square.customers.RawGroupsClient;
import com.squareup.square.customers.types.AddGroupsRequest;
import com.squareup.square.customers.types.CreateCustomerGroupRequest;
import com.squareup.square.customers.types.DeleteGroupsRequest;
import com.squareup.square.customers.types.GetGroupsRequest;
import com.squareup.square.customers.types.ListGroupsRequest;
import com.squareup.square.customers.types.RemoveGroupsRequest;
import com.squareup.square.customers.types.UpdateCustomerGroupRequest;
import com.squareup.square.types.AddGroupToCustomerResponse;
import com.squareup.square.types.CreateCustomerGroupResponse;
import com.squareup.square.types.CustomerGroup;
import com.squareup.square.types.DeleteCustomerGroupResponse;
import com.squareup.square.types.GetCustomerGroupResponse;
import com.squareup.square.types.RemoveGroupFromCustomerResponse;
import com.squareup.square.types.UpdateCustomerGroupResponse;

public class GroupsClient {
    protected final ClientOptions clientOptions;
    private final RawGroupsClient rawClient;

    public GroupsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawGroupsClient(clientOptions);
    }

    public RawGroupsClient withRawResponse() {
        return this.rawClient;
    }

    public SyncPagingIterable<CustomerGroup> list() {
        return this.rawClient.list().body();
    }

    public SyncPagingIterable<CustomerGroup> list(ListGroupsRequest request) {
        return this.rawClient.list(request).body();
    }

    public SyncPagingIterable<CustomerGroup> list(ListGroupsRequest request, RequestOptions requestOptions) {
        return this.rawClient.list(request, requestOptions).body();
    }

    public CreateCustomerGroupResponse create(CreateCustomerGroupRequest request) {
        return this.rawClient.create(request).body();
    }

    public CreateCustomerGroupResponse create(CreateCustomerGroupRequest request, RequestOptions requestOptions) {
        return this.rawClient.create(request, requestOptions).body();
    }

    public GetCustomerGroupResponse get(GetGroupsRequest request) {
        return this.rawClient.get(request).body();
    }

    public GetCustomerGroupResponse get(GetGroupsRequest request, RequestOptions requestOptions) {
        return this.rawClient.get(request, requestOptions).body();
    }

    public UpdateCustomerGroupResponse update(UpdateCustomerGroupRequest request) {
        return this.rawClient.update(request).body();
    }

    public UpdateCustomerGroupResponse update(UpdateCustomerGroupRequest request, RequestOptions requestOptions) {
        return this.rawClient.update(request, requestOptions).body();
    }

    public DeleteCustomerGroupResponse delete(DeleteGroupsRequest request) {
        return this.rawClient.delete(request).body();
    }

    public DeleteCustomerGroupResponse delete(DeleteGroupsRequest request, RequestOptions requestOptions) {
        return this.rawClient.delete(request, requestOptions).body();
    }

    public AddGroupToCustomerResponse add(AddGroupsRequest request) {
        return this.rawClient.add(request).body();
    }

    public AddGroupToCustomerResponse add(AddGroupsRequest request, RequestOptions requestOptions) {
        return this.rawClient.add(request, requestOptions).body();
    }

    public RemoveGroupFromCustomerResponse remove(RemoveGroupsRequest request) {
        return this.rawClient.remove(request).body();
    }

    public RemoveGroupFromCustomerResponse remove(RemoveGroupsRequest request, RequestOptions requestOptions) {
        return this.rawClient.remove(request, requestOptions).body();
    }
}

