/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.customers;

import com.squareup.square.core.ClientOptions;
import com.squareup.square.core.RequestOptions;
import com.squareup.square.core.SyncPagingIterable;
import com.squareup.square.customers.AsyncRawGroupsClient;
import com.squareup.square.customers.types.AddGroupsRequest;
import com.squareup.square.customers.types.CreateCustomerGroupRequest;
import com.squareup.square.customers.types.DeleteGroupsRequest;
import com.squareup.square.customers.types.GetGroupsRequest;
import com.squareup.square.customers.types.ListGroupsRequest;
import com.squareup.square.customers.types.RemoveGroupsRequest;
import com.squareup.square.customers.types.UpdateCustomerGroupRequest;
import com.squareup.square.types.AddGroupToCustomerResponse;
import com.squareup.square.types.CreateCustomerGroupResponse;
import com.squareup.square.types.CustomerGroup;
import com.squareup.square.types.DeleteCustomerGroupResponse;
import com.squareup.square.types.GetCustomerGroupResponse;
import com.squareup.square.types.RemoveGroupFromCustomerResponse;
import com.squareup.square.types.UpdateCustomerGroupResponse;
import java.util.concurrent.CompletableFuture;

public class AsyncGroupsClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawGroupsClient rawClient;

    public AsyncGroupsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawGroupsClient(clientOptions);
    }

    public AsyncRawGroupsClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<SyncPagingIterable<CustomerGroup>> list() {
        return this.rawClient.list().thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<SyncPagingIterable<CustomerGroup>> list(ListGroupsRequest request) {
        return this.rawClient.list(request).thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<SyncPagingIterable<CustomerGroup>> list(ListGroupsRequest request, RequestOptions requestOptions) {
        return this.rawClient.list(request, requestOptions).thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<CreateCustomerGroupResponse> create(CreateCustomerGroupRequest request) {
        return this.rawClient.create(request).thenApply(response -> (CreateCustomerGroupResponse)response.body());
    }

    public CompletableFuture<CreateCustomerGroupResponse> create(CreateCustomerGroupRequest request, RequestOptions requestOptions) {
        return this.rawClient.create(request, requestOptions).thenApply(response -> (CreateCustomerGroupResponse)response.body());
    }

    public CompletableFuture<GetCustomerGroupResponse> get(GetGroupsRequest request) {
        return this.rawClient.get(request).thenApply(response -> (GetCustomerGroupResponse)response.body());
    }

    public CompletableFuture<GetCustomerGroupResponse> get(GetGroupsRequest request, RequestOptions requestOptions) {
        return this.rawClient.get(request, requestOptions).thenApply(response -> (GetCustomerGroupResponse)response.body());
    }

    public CompletableFuture<UpdateCustomerGroupResponse> update(UpdateCustomerGroupRequest request) {
        return this.rawClient.update(request).thenApply(response -> (UpdateCustomerGroupResponse)response.body());
    }

    public CompletableFuture<UpdateCustomerGroupResponse> update(UpdateCustomerGroupRequest request, RequestOptions requestOptions) {
        return this.rawClient.update(request, requestOptions).thenApply(response -> (UpdateCustomerGroupResponse)response.body());
    }

    public CompletableFuture<DeleteCustomerGroupResponse> delete(DeleteGroupsRequest request) {
        return this.rawClient.delete(request).thenApply(response -> (DeleteCustomerGroupResponse)response.body());
    }

    public CompletableFuture<DeleteCustomerGroupResponse> delete(DeleteGroupsRequest request, RequestOptions requestOptions) {
        return this.rawClient.delete(request, requestOptions).thenApply(response -> (DeleteCustomerGroupResponse)response.body());
    }

    public CompletableFuture<AddGroupToCustomerResponse> add(AddGroupsRequest request) {
        return this.rawClient.add(request).thenApply(response -> (AddGroupToCustomerResponse)response.body());
    }

    public CompletableFuture<AddGroupToCustomerResponse> add(AddGroupsRequest request, RequestOptions requestOptions) {
        return this.rawClient.add(request, requestOptions).thenApply(response -> (AddGroupToCustomerResponse)response.body());
    }

    public CompletableFuture<RemoveGroupFromCustomerResponse> remove(RemoveGroupsRequest request) {
        return this.rawClient.remove(request).thenApply(response -> (RemoveGroupFromCustomerResponse)response.body());
    }

    public CompletableFuture<RemoveGroupFromCustomerResponse> remove(RemoveGroupsRequest request, RequestOptions requestOptions) {
        return this.rawClient.remove(request, requestOptions).thenApply(response -> (RemoveGroupFromCustomerResponse)response.body());
    }
}

