/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.customers;

import com.squareup.square.core.ClientOptions;
import com.squareup.square.core.RequestOptions;
import com.squareup.square.core.SyncPagingIterable;
import com.squareup.square.customers.AsyncRawCustomAttributesClient;
import com.squareup.square.customers.types.DeleteCustomAttributesRequest;
import com.squareup.square.customers.types.GetCustomAttributesRequest;
import com.squareup.square.customers.types.ListCustomAttributesRequest;
import com.squareup.square.customers.types.UpsertCustomerCustomAttributeRequest;
import com.squareup.square.types.CustomAttribute;
import com.squareup.square.types.DeleteCustomerCustomAttributeResponse;
import com.squareup.square.types.GetCustomerCustomAttributeResponse;
import com.squareup.square.types.UpsertCustomerCustomAttributeResponse;
import java.util.concurrent.CompletableFuture;

public class AsyncCustomAttributesClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawCustomAttributesClient rawClient;

    public AsyncCustomAttributesClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawCustomAttributesClient(clientOptions);
    }

    public AsyncRawCustomAttributesClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<SyncPagingIterable<CustomAttribute>> list(ListCustomAttributesRequest request) {
        return this.rawClient.list(request).thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<SyncPagingIterable<CustomAttribute>> list(ListCustomAttributesRequest request, RequestOptions requestOptions) {
        return this.rawClient.list(request, requestOptions).thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<GetCustomerCustomAttributeResponse> get(GetCustomAttributesRequest request) {
        return this.rawClient.get(request).thenApply(response -> (GetCustomerCustomAttributeResponse)response.body());
    }

    public CompletableFuture<GetCustomerCustomAttributeResponse> get(GetCustomAttributesRequest request, RequestOptions requestOptions) {
        return this.rawClient.get(request, requestOptions).thenApply(response -> (GetCustomerCustomAttributeResponse)response.body());
    }

    public CompletableFuture<UpsertCustomerCustomAttributeResponse> upsert(UpsertCustomerCustomAttributeRequest request) {
        return this.rawClient.upsert(request).thenApply(response -> (UpsertCustomerCustomAttributeResponse)response.body());
    }

    public CompletableFuture<UpsertCustomerCustomAttributeResponse> upsert(UpsertCustomerCustomAttributeRequest request, RequestOptions requestOptions) {
        return this.rawClient.upsert(request, requestOptions).thenApply(response -> (UpsertCustomerCustomAttributeResponse)response.body());
    }

    public CompletableFuture<DeleteCustomerCustomAttributeResponse> delete(DeleteCustomAttributesRequest request) {
        return this.rawClient.delete(request).thenApply(response -> (DeleteCustomerCustomAttributeResponse)response.body());
    }

    public CompletableFuture<DeleteCustomerCustomAttributeResponse> delete(DeleteCustomAttributesRequest request, RequestOptions requestOptions) {
        return this.rawClient.delete(request, requestOptions).thenApply(response -> (DeleteCustomerCustomAttributeResponse)response.body());
    }
}

