/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.core;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.core.SquareException;
import com.squareup.square.types.Error;
import com.squareup.square.types.ErrorCategory;
import com.squareup.square.types.ErrorCode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import okhttp3.Response;

public class SquareApiException
extends SquareException {
    private static final String V1_CODE_KEY = "type";
    private static final String ERRORS_KEY = "errors";
    private static final String V1_DETAIL_KEY = "message";
    private static final String FIELD_KEY = "field";
    private static final Error FALLBACK_ERROR = Error.builder().category(ErrorCategory.API_ERROR).code(ErrorCode.valueOf("UNKNOWN")).build();
    private final int statusCode;
    private final Object body;
    private final Map<String, List<String>> headers = new HashMap<String, List<String>>();
    private final List<Error> errors;

    public SquareApiException(String message, int statusCode, Object body) {
        super(message);
        this.statusCode = statusCode;
        this.body = body;
        this.errors = SquareApiException.parseErrors(body);
    }

    public SquareApiException(String message, int statusCode, Object body, Response rawResponse) {
        super(message);
        this.statusCode = statusCode;
        this.body = body;
        this.errors = SquareApiException.parseErrors(body);
        rawResponse.headers().forEach(header -> {
            String key = (String)header.component1();
            String value = (String)header.component2();
            this.headers.computeIfAbsent(key, _str -> new ArrayList()).add(value);
        });
    }

    public int statusCode() {
        return this.statusCode;
    }

    public Object body() {
        return this.body;
    }

    public List<Error> errors() {
        return this.errors;
    }

    public Map<String, List<String>> headers() {
        return this.headers;
    }

    @Override
    public String toString() {
        return "SquareClientApiException{message: " + this.getMessage() + ", statusCode: " + this.statusCode + ", body: " + this.body + "}";
    }

    private static List<Error> parseErrors(Object body) {
        ArrayList<Error> errors = new ArrayList<Error>();
        JsonNode json = ObjectMappers.JSON_MAPPER.valueToTree(body);
        if (json.isValueNode()) {
            if (!json.isTextual()) {
                errors.add(FALLBACK_ERROR);
                return errors;
            }
            try {
                json = ObjectMappers.JSON_MAPPER.readTree(json.textValue());
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }
        if (json.isObject()) {
            JsonNode errorsNode = json.get(ERRORS_KEY);
            if (errorsNode != null) {
                if (!errorsNode.isArray()) {
                    errors.add(FALLBACK_ERROR);
                    return errors;
                }
                json = errorsNode;
            } else {
                Optional<ErrorCode> code = Optional.ofNullable(json.get(V1_CODE_KEY)).filter(JsonNode::isTextual).map(JsonNode::textValue).map(ErrorCode::valueOf);
                Optional<String> detail = Optional.ofNullable(json.get(V1_DETAIL_KEY)).filter(JsonNode::isTextual).map(JsonNode::textValue);
                Optional<String> field = Optional.ofNullable(json.get(FIELD_KEY)).filter(JsonNode::isTextual).map(JsonNode::textValue);
                errors.add(Error.builder().category(ErrorCategory.API_ERROR).code(code.orElse(ErrorCode.valueOf("UNKNOWN"))).detail(detail).field(field).build());
                return errors;
            }
        }
        if (json.isArray()) {
            for (JsonNode errorNode : json) {
                try {
                    errors.add((Error)ObjectMappers.JSON_MAPPER.readValue(errorNode.toString(), Error.class));
                }
                catch (JsonProcessingException e) {
                    Optional<ErrorCode> code = Optional.ofNullable(errorNode.get(V1_CODE_KEY)).filter(JsonNode::isTextual).map(JsonNode::textValue).map(ErrorCode::valueOf);
                    Optional<String> detail = Optional.ofNullable(errorNode.get(V1_CODE_KEY)).filter(JsonNode::isTextual).map(JsonNode::textValue);
                    Optional<String> field = Optional.ofNullable(errorNode.get(FIELD_KEY)).filter(JsonNode::isTextual).map(JsonNode::textValue);
                    errors.add(Error.builder().from(FALLBACK_ERROR).category(ErrorCategory.API_ERROR).code(code.orElse(ErrorCode.valueOf("UNKNOWN"))).detail(detail).field(field).build());
                }
            }
            return errors;
        }
        errors.add(FALLBACK_ERROR);
        return errors;
    }
}

