/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.checkout.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.CheckoutOptions;
import com.squareup.square.types.Order;
import com.squareup.square.types.PrePopulatedData;
import com.squareup.square.types.QuickPay;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CreatePaymentLinkRequest {
    private final Optional<String> idempotencyKey;
    private final Optional<String> description;
    private final Optional<QuickPay> quickPay;
    private final Optional<Order> order;
    private final Optional<CheckoutOptions> checkoutOptions;
    private final Optional<PrePopulatedData> prePopulatedData;
    private final Optional<String> paymentNote;
    private final Map<String, Object> additionalProperties;

    private CreatePaymentLinkRequest(Optional<String> idempotencyKey, Optional<String> description, Optional<QuickPay> quickPay, Optional<Order> order, Optional<CheckoutOptions> checkoutOptions, Optional<PrePopulatedData> prePopulatedData, Optional<String> paymentNote, Map<String, Object> additionalProperties) {
        this.idempotencyKey = idempotencyKey;
        this.description = description;
        this.quickPay = quickPay;
        this.order = order;
        this.checkoutOptions = checkoutOptions;
        this.prePopulatedData = prePopulatedData;
        this.paymentNote = paymentNote;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="idempotency_key")
    public Optional<String> getIdempotencyKey() {
        return this.idempotencyKey;
    }

    @JsonProperty(value="description")
    public Optional<String> getDescription() {
        return this.description;
    }

    @JsonProperty(value="quick_pay")
    public Optional<QuickPay> getQuickPay() {
        return this.quickPay;
    }

    @JsonProperty(value="order")
    public Optional<Order> getOrder() {
        return this.order;
    }

    @JsonProperty(value="checkout_options")
    public Optional<CheckoutOptions> getCheckoutOptions() {
        return this.checkoutOptions;
    }

    @JsonProperty(value="pre_populated_data")
    public Optional<PrePopulatedData> getPrePopulatedData() {
        return this.prePopulatedData;
    }

    @JsonProperty(value="payment_note")
    public Optional<String> getPaymentNote() {
        return this.paymentNote;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CreatePaymentLinkRequest && this.equalTo((CreatePaymentLinkRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreatePaymentLinkRequest other) {
        return this.idempotencyKey.equals(other.idempotencyKey) && this.description.equals(other.description) && this.quickPay.equals(other.quickPay) && this.order.equals(other.order) && this.checkoutOptions.equals(other.checkoutOptions) && this.prePopulatedData.equals(other.prePopulatedData) && this.paymentNote.equals(other.paymentNote);
    }

    public int hashCode() {
        return Objects.hash(this.idempotencyKey, this.description, this.quickPay, this.order, this.checkoutOptions, this.prePopulatedData, this.paymentNote);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> idempotencyKey = Optional.empty();
        private Optional<String> description = Optional.empty();
        private Optional<QuickPay> quickPay = Optional.empty();
        private Optional<Order> order = Optional.empty();
        private Optional<CheckoutOptions> checkoutOptions = Optional.empty();
        private Optional<PrePopulatedData> prePopulatedData = Optional.empty();
        private Optional<String> paymentNote = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(CreatePaymentLinkRequest other) {
            this.idempotencyKey(other.getIdempotencyKey());
            this.description(other.getDescription());
            this.quickPay(other.getQuickPay());
            this.order(other.getOrder());
            this.checkoutOptions(other.getCheckoutOptions());
            this.prePopulatedData(other.getPrePopulatedData());
            this.paymentNote(other.getPaymentNote());
            return this;
        }

        @JsonSetter(value="idempotency_key", nulls=Nulls.SKIP)
        public Builder idempotencyKey(Optional<String> idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public Builder idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = Optional.ofNullable(idempotencyKey);
            return this;
        }

        @JsonSetter(value="description", nulls=Nulls.SKIP)
        public Builder description(Optional<String> description) {
            this.description = description;
            return this;
        }

        public Builder description(String description) {
            this.description = Optional.ofNullable(description);
            return this;
        }

        @JsonSetter(value="quick_pay", nulls=Nulls.SKIP)
        public Builder quickPay(Optional<QuickPay> quickPay) {
            this.quickPay = quickPay;
            return this;
        }

        public Builder quickPay(QuickPay quickPay) {
            this.quickPay = Optional.ofNullable(quickPay);
            return this;
        }

        @JsonSetter(value="order", nulls=Nulls.SKIP)
        public Builder order(Optional<Order> order) {
            this.order = order;
            return this;
        }

        public Builder order(Order order) {
            this.order = Optional.ofNullable(order);
            return this;
        }

        @JsonSetter(value="checkout_options", nulls=Nulls.SKIP)
        public Builder checkoutOptions(Optional<CheckoutOptions> checkoutOptions) {
            this.checkoutOptions = checkoutOptions;
            return this;
        }

        public Builder checkoutOptions(CheckoutOptions checkoutOptions) {
            this.checkoutOptions = Optional.ofNullable(checkoutOptions);
            return this;
        }

        @JsonSetter(value="pre_populated_data", nulls=Nulls.SKIP)
        public Builder prePopulatedData(Optional<PrePopulatedData> prePopulatedData) {
            this.prePopulatedData = prePopulatedData;
            return this;
        }

        public Builder prePopulatedData(PrePopulatedData prePopulatedData) {
            this.prePopulatedData = Optional.ofNullable(prePopulatedData);
            return this;
        }

        @JsonSetter(value="payment_note", nulls=Nulls.SKIP)
        public Builder paymentNote(Optional<String> paymentNote) {
            this.paymentNote = paymentNote;
            return this;
        }

        public Builder paymentNote(String paymentNote) {
            this.paymentNote = Optional.ofNullable(paymentNote);
            return this;
        }

        public CreatePaymentLinkRequest build() {
            return new CreatePaymentLinkRequest(this.idempotencyKey, this.description, this.quickPay, this.order, this.checkoutOptions, this.prePopulatedData, this.paymentNote, this.additionalProperties);
        }
    }
}

