/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.catalog.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.UpdateCatalogImageRequest;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class UpdateImagesRequest {
    private final Optional<File> imageFile;
    private final String imageId;
    private final Optional<UpdateCatalogImageRequest> request;
    private final Map<String, Object> additionalProperties;

    private UpdateImagesRequest(Optional<File> imageFile, String imageId, Optional<UpdateCatalogImageRequest> request, Map<String, Object> additionalProperties) {
        this.imageFile = imageFile;
        this.imageId = imageId;
        this.request = request;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="image_file")
    public Optional<File> getImageFile() {
        return this.imageFile;
    }

    @JsonProperty(value="image_id")
    public String getImageId() {
        return this.imageId;
    }

    @JsonProperty(value="request")
    public Optional<UpdateCatalogImageRequest> getRequest() {
        return this.request;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof UpdateImagesRequest && this.equalTo((UpdateImagesRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(UpdateImagesRequest other) {
        return this.imageFile.equals(other.imageFile) && this.imageId.equals(other.imageId) && this.request.equals(other.request);
    }

    public int hashCode() {
        return Objects.hash(this.imageFile, this.imageId, this.request);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ImageIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements ImageIdStage,
    _FinalStage {
        private String imageId;
        private Optional<UpdateCatalogImageRequest> request = Optional.empty();
        private Optional<File> imageFile = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(UpdateImagesRequest other) {
            this.imageFile(other.getImageFile());
            this.imageId(other.getImageId());
            this.request(other.getRequest());
            return this;
        }

        @Override
        @JsonSetter(value="image_id")
        public _FinalStage imageId(@NotNull String imageId) {
            this.imageId = Objects.requireNonNull(imageId, "imageId must not be null");
            return this;
        }

        @Override
        public _FinalStage request(UpdateCatalogImageRequest request) {
            this.request = Optional.ofNullable(request);
            return this;
        }

        @Override
        @JsonSetter(value="request", nulls=Nulls.SKIP)
        public _FinalStage request(Optional<UpdateCatalogImageRequest> request) {
            this.request = request;
            return this;
        }

        @Override
        public _FinalStage imageFile(File imageFile) {
            this.imageFile = Optional.ofNullable(imageFile);
            return this;
        }

        @Override
        @JsonSetter(value="image_file", nulls=Nulls.SKIP)
        public _FinalStage imageFile(Optional<File> imageFile) {
            this.imageFile = imageFile;
            return this;
        }

        @Override
        public UpdateImagesRequest build() {
            return new UpdateImagesRequest(this.imageFile, this.imageId, this.request, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public UpdateImagesRequest build();

        public _FinalStage imageFile(Optional<File> var1);

        public _FinalStage imageFile(File var1);

        public _FinalStage request(Optional<UpdateCatalogImageRequest> var1);

        public _FinalStage request(UpdateCatalogImageRequest var1);
    }

    public static interface ImageIdStage {
        public _FinalStage imageId(@NotNull String var1);

        public Builder from(UpdateImagesRequest var1);
    }
}

