/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.catalog.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class GetObjectRequest {
    private final String objectId;
    private final Optional<Boolean> includeRelatedObjects;
    private final Optional<Long> catalogVersion;
    private final Optional<Boolean> includeCategoryPathToRoot;
    private final Map<String, Object> additionalProperties;

    private GetObjectRequest(String objectId, Optional<Boolean> includeRelatedObjects, Optional<Long> catalogVersion, Optional<Boolean> includeCategoryPathToRoot, Map<String, Object> additionalProperties) {
        this.objectId = objectId;
        this.includeRelatedObjects = includeRelatedObjects;
        this.catalogVersion = catalogVersion;
        this.includeCategoryPathToRoot = includeCategoryPathToRoot;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="object_id")
    public String getObjectId() {
        return this.objectId;
    }

    @JsonIgnore
    public Optional<Boolean> getIncludeRelatedObjects() {
        if (this.includeRelatedObjects == null) {
            return Optional.empty();
        }
        return this.includeRelatedObjects;
    }

    @JsonIgnore
    public Optional<Long> getCatalogVersion() {
        if (this.catalogVersion == null) {
            return Optional.empty();
        }
        return this.catalogVersion;
    }

    @JsonIgnore
    public Optional<Boolean> getIncludeCategoryPathToRoot() {
        if (this.includeCategoryPathToRoot == null) {
            return Optional.empty();
        }
        return this.includeCategoryPathToRoot;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="include_related_objects")
    private Optional<Boolean> _getIncludeRelatedObjects() {
        return this.includeRelatedObjects;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="catalog_version")
    private Optional<Long> _getCatalogVersion() {
        return this.catalogVersion;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="include_category_path_to_root")
    private Optional<Boolean> _getIncludeCategoryPathToRoot() {
        return this.includeCategoryPathToRoot;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof GetObjectRequest && this.equalTo((GetObjectRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(GetObjectRequest other) {
        return this.objectId.equals(other.objectId) && this.includeRelatedObjects.equals(other.includeRelatedObjects) && this.catalogVersion.equals(other.catalogVersion) && this.includeCategoryPathToRoot.equals(other.includeCategoryPathToRoot);
    }

    public int hashCode() {
        return Objects.hash(this.objectId, this.includeRelatedObjects, this.catalogVersion, this.includeCategoryPathToRoot);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ObjectIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements ObjectIdStage,
    _FinalStage {
        private String objectId;
        private Optional<Boolean> includeCategoryPathToRoot = Optional.empty();
        private Optional<Long> catalogVersion = Optional.empty();
        private Optional<Boolean> includeRelatedObjects = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(GetObjectRequest other) {
            this.objectId(other.getObjectId());
            this.includeRelatedObjects(other.getIncludeRelatedObjects());
            this.catalogVersion(other.getCatalogVersion());
            this.includeCategoryPathToRoot(other.getIncludeCategoryPathToRoot());
            return this;
        }

        @Override
        @JsonSetter(value="object_id")
        public _FinalStage objectId(@NotNull String objectId) {
            this.objectId = Objects.requireNonNull(objectId, "objectId must not be null");
            return this;
        }

        @Override
        public _FinalStage includeCategoryPathToRoot(Nullable<Boolean> includeCategoryPathToRoot) {
            this.includeCategoryPathToRoot = includeCategoryPathToRoot.isNull() ? null : (includeCategoryPathToRoot.isEmpty() ? Optional.empty() : Optional.of(includeCategoryPathToRoot.get()));
            return this;
        }

        @Override
        public _FinalStage includeCategoryPathToRoot(Boolean includeCategoryPathToRoot) {
            this.includeCategoryPathToRoot = Optional.ofNullable(includeCategoryPathToRoot);
            return this;
        }

        @Override
        @JsonSetter(value="include_category_path_to_root", nulls=Nulls.SKIP)
        public _FinalStage includeCategoryPathToRoot(Optional<Boolean> includeCategoryPathToRoot) {
            this.includeCategoryPathToRoot = includeCategoryPathToRoot;
            return this;
        }

        @Override
        public _FinalStage catalogVersion(Nullable<Long> catalogVersion) {
            this.catalogVersion = catalogVersion.isNull() ? null : (catalogVersion.isEmpty() ? Optional.empty() : Optional.of(catalogVersion.get()));
            return this;
        }

        @Override
        public _FinalStage catalogVersion(Long catalogVersion) {
            this.catalogVersion = Optional.ofNullable(catalogVersion);
            return this;
        }

        @Override
        @JsonSetter(value="catalog_version", nulls=Nulls.SKIP)
        public _FinalStage catalogVersion(Optional<Long> catalogVersion) {
            this.catalogVersion = catalogVersion;
            return this;
        }

        @Override
        public _FinalStage includeRelatedObjects(Nullable<Boolean> includeRelatedObjects) {
            this.includeRelatedObjects = includeRelatedObjects.isNull() ? null : (includeRelatedObjects.isEmpty() ? Optional.empty() : Optional.of(includeRelatedObjects.get()));
            return this;
        }

        @Override
        public _FinalStage includeRelatedObjects(Boolean includeRelatedObjects) {
            this.includeRelatedObjects = Optional.ofNullable(includeRelatedObjects);
            return this;
        }

        @Override
        @JsonSetter(value="include_related_objects", nulls=Nulls.SKIP)
        public _FinalStage includeRelatedObjects(Optional<Boolean> includeRelatedObjects) {
            this.includeRelatedObjects = includeRelatedObjects;
            return this;
        }

        @Override
        public GetObjectRequest build() {
            return new GetObjectRequest(this.objectId, this.includeRelatedObjects, this.catalogVersion, this.includeCategoryPathToRoot, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public GetObjectRequest build();

        public _FinalStage includeRelatedObjects(Optional<Boolean> var1);

        public _FinalStage includeRelatedObjects(Boolean var1);

        public _FinalStage includeRelatedObjects(Nullable<Boolean> var1);

        public _FinalStage catalogVersion(Optional<Long> var1);

        public _FinalStage catalogVersion(Long var1);

        public _FinalStage catalogVersion(Nullable<Long> var1);

        public _FinalStage includeCategoryPathToRoot(Optional<Boolean> var1);

        public _FinalStage includeCategoryPathToRoot(Boolean var1);

        public _FinalStage includeCategoryPathToRoot(Nullable<Boolean> var1);
    }

    public static interface ObjectIdStage {
        public _FinalStage objectId(@NotNull String var1);

        public Builder from(GetObjectRequest var1);
    }
}

