/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square;

import com.squareup.square.core.ClientOptions;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.core.QueryStringMapper;
import com.squareup.square.core.RequestOptions;
import com.squareup.square.core.SquareApiException;
import com.squareup.square.core.SquareClientHttpResponse;
import com.squareup.square.core.SquareException;
import com.squareup.square.core.SyncPagingIterable;
import com.squareup.square.types.GetPayoutResponse;
import com.squareup.square.types.GetPayoutsRequest;
import com.squareup.square.types.ListEntriesPayoutsRequest;
import com.squareup.square.types.ListPayoutEntriesResponse;
import com.squareup.square.types.ListPayoutsRequest;
import com.squareup.square.types.ListPayoutsResponse;
import com.squareup.square.types.Payout;
import com.squareup.square.types.PayoutEntry;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class RawPayoutsClient {
    protected final ClientOptions clientOptions;

    public RawPayoutsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    public SquareClientHttpResponse<SyncPagingIterable<Payout>> list() {
        return this.list(ListPayoutsRequest.builder().build());
    }

    public SquareClientHttpResponse<SyncPagingIterable<Payout>> list(ListPayoutsRequest request) {
        return this.list(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SquareClientHttpResponse<SyncPagingIterable<Payout>> list(ListPayoutsRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/payouts");
        if (request.getLocationId().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "location_id", request.getLocationId().get(), false);
        }
        if (request.getStatus().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "status", request.getStatus().get(), false);
        }
        if (request.getBeginTime().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "begin_time", request.getBeginTime().get(), false);
        }
        if (request.getEndTime().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "end_time", request.getEndTime().get(), false);
        }
        if (request.getSortOrder().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "sort_order", request.getSortOrder().get(), false);
        }
        if (request.getCursor().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "cursor", request.getCursor().get(), false);
        }
        if (request.getLimit().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "limit", request.getLimit().get(), false);
        }
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                ListPayoutsResponse parsedResponse = (ListPayoutsResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), ListPayoutsResponse.class);
                Optional<String> startingAfter = parsedResponse.getCursor();
                ListPayoutsRequest nextRequest = ListPayoutsRequest.builder().from(request).cursor(startingAfter).build();
                List result = parsedResponse.getPayouts().orElse(Collections.emptyList());
                SquareClientHttpResponse<SyncPagingIterable<Payout>> squareClientHttpResponse = new SquareClientHttpResponse<SyncPagingIterable<Payout>>(new SyncPagingIterable(startingAfter.isPresent(), result, () -> this.list(nextRequest, requestOptions).body()), response);
                return squareClientHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            throw new SquareApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new SquareException("Network error executing HTTP request", e);
        }
    }

    public SquareClientHttpResponse<GetPayoutResponse> get(GetPayoutsRequest request) {
        return this.get(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SquareClientHttpResponse<GetPayoutResponse> get(GetPayoutsRequest request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/payouts").addPathSegment(request.getPayoutId()).build();
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                SquareClientHttpResponse<GetPayoutResponse> squareClientHttpResponse = new SquareClientHttpResponse<GetPayoutResponse>((GetPayoutResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), GetPayoutResponse.class), response);
                return squareClientHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            throw new SquareApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new SquareException("Network error executing HTTP request", e);
        }
    }

    public SquareClientHttpResponse<SyncPagingIterable<PayoutEntry>> listEntries(ListEntriesPayoutsRequest request) {
        return this.listEntries(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SquareClientHttpResponse<SyncPagingIterable<PayoutEntry>> listEntries(ListEntriesPayoutsRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/payouts").addPathSegment(request.getPayoutId()).addPathSegments("payout-entries");
        if (request.getSortOrder().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "sort_order", request.getSortOrder().get(), false);
        }
        if (request.getCursor().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "cursor", request.getCursor().get(), false);
        }
        if (request.getLimit().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "limit", request.getLimit().get(), false);
        }
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                ListPayoutEntriesResponse parsedResponse = (ListPayoutEntriesResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), ListPayoutEntriesResponse.class);
                Optional<String> startingAfter = parsedResponse.getCursor();
                ListEntriesPayoutsRequest nextRequest = ListEntriesPayoutsRequest.builder().from(request).cursor(startingAfter).build();
                List result = parsedResponse.getPayoutEntries().orElse(Collections.emptyList());
                SquareClientHttpResponse<SyncPagingIterable<PayoutEntry>> squareClientHttpResponse = new SquareClientHttpResponse<SyncPagingIterable<PayoutEntry>>(new SyncPagingIterable(startingAfter.isPresent(), result, () -> this.listEntries(nextRequest, requestOptions).body()), response);
                return squareClientHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            throw new SquareApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new SquareException("Network error executing HTTP request", e);
        }
    }
}

