/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.squareup.square.core.ClientOptions;
import com.squareup.square.core.MediaTypes;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.core.QueryStringMapper;
import com.squareup.square.core.RequestOptions;
import com.squareup.square.core.SquareApiException;
import com.squareup.square.core.SquareClientHttpResponse;
import com.squareup.square.core.SquareException;
import com.squareup.square.core.SyncPagingIterable;
import com.squareup.square.types.BatchChangeInventoryRequest;
import com.squareup.square.types.BatchChangeInventoryResponse;
import com.squareup.square.types.BatchGetInventoryChangesResponse;
import com.squareup.square.types.BatchGetInventoryCountsRequest;
import com.squareup.square.types.BatchGetInventoryCountsResponse;
import com.squareup.square.types.BatchRetrieveInventoryChangesRequest;
import com.squareup.square.types.ChangesInventoryRequest;
import com.squareup.square.types.DeprecatedGetAdjustmentInventoryRequest;
import com.squareup.square.types.DeprecatedGetPhysicalCountInventoryRequest;
import com.squareup.square.types.GetAdjustmentInventoryRequest;
import com.squareup.square.types.GetInventoryAdjustmentResponse;
import com.squareup.square.types.GetInventoryChangesResponse;
import com.squareup.square.types.GetInventoryCountResponse;
import com.squareup.square.types.GetInventoryPhysicalCountResponse;
import com.squareup.square.types.GetInventoryRequest;
import com.squareup.square.types.GetInventoryTransferResponse;
import com.squareup.square.types.GetPhysicalCountInventoryRequest;
import com.squareup.square.types.GetTransferInventoryRequest;
import com.squareup.square.types.InventoryChange;
import com.squareup.square.types.InventoryCount;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class RawInventoryClient {
    protected final ClientOptions clientOptions;

    public RawInventoryClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    public SquareClientHttpResponse<GetInventoryAdjustmentResponse> deprecatedGetAdjustment(DeprecatedGetAdjustmentInventoryRequest request) {
        return this.deprecatedGetAdjustment(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SquareClientHttpResponse<GetInventoryAdjustmentResponse> deprecatedGetAdjustment(DeprecatedGetAdjustmentInventoryRequest request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/inventory/adjustment").addPathSegment(request.getAdjustmentId()).build();
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                SquareClientHttpResponse<GetInventoryAdjustmentResponse> squareClientHttpResponse = new SquareClientHttpResponse<GetInventoryAdjustmentResponse>((GetInventoryAdjustmentResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), GetInventoryAdjustmentResponse.class), response);
                return squareClientHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            throw new SquareApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new SquareException("Network error executing HTTP request", e);
        }
    }

    public SquareClientHttpResponse<GetInventoryAdjustmentResponse> getAdjustment(GetAdjustmentInventoryRequest request) {
        return this.getAdjustment(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SquareClientHttpResponse<GetInventoryAdjustmentResponse> getAdjustment(GetAdjustmentInventoryRequest request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/inventory/adjustments").addPathSegment(request.getAdjustmentId()).build();
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                SquareClientHttpResponse<GetInventoryAdjustmentResponse> squareClientHttpResponse = new SquareClientHttpResponse<GetInventoryAdjustmentResponse>((GetInventoryAdjustmentResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), GetInventoryAdjustmentResponse.class), response);
                return squareClientHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            throw new SquareApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new SquareException("Network error executing HTTP request", e);
        }
    }

    public SquareClientHttpResponse<BatchChangeInventoryResponse> deprecatedBatchChange(BatchChangeInventoryRequest request) {
        return this.deprecatedBatchChange(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SquareClientHttpResponse<BatchChangeInventoryResponse> deprecatedBatchChange(BatchChangeInventoryRequest request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/inventory/batch-change").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new SquareException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                SquareClientHttpResponse<BatchChangeInventoryResponse> squareClientHttpResponse = new SquareClientHttpResponse<BatchChangeInventoryResponse>((BatchChangeInventoryResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), BatchChangeInventoryResponse.class), response);
                return squareClientHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            throw new SquareApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new SquareException("Network error executing HTTP request", e);
        }
    }

    public SquareClientHttpResponse<BatchGetInventoryChangesResponse> deprecatedBatchGetChanges() {
        return this.deprecatedBatchGetChanges(BatchRetrieveInventoryChangesRequest.builder().build());
    }

    public SquareClientHttpResponse<BatchGetInventoryChangesResponse> deprecatedBatchGetChanges(BatchRetrieveInventoryChangesRequest request) {
        return this.deprecatedBatchGetChanges(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SquareClientHttpResponse<BatchGetInventoryChangesResponse> deprecatedBatchGetChanges(BatchRetrieveInventoryChangesRequest request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/inventory/batch-retrieve-changes").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new SquareException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                SquareClientHttpResponse<BatchGetInventoryChangesResponse> squareClientHttpResponse = new SquareClientHttpResponse<BatchGetInventoryChangesResponse>((BatchGetInventoryChangesResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), BatchGetInventoryChangesResponse.class), response);
                return squareClientHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            throw new SquareApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new SquareException("Network error executing HTTP request", e);
        }
    }

    public SquareClientHttpResponse<BatchGetInventoryCountsResponse> deprecatedBatchGetCounts() {
        return this.deprecatedBatchGetCounts(BatchGetInventoryCountsRequest.builder().build());
    }

    public SquareClientHttpResponse<BatchGetInventoryCountsResponse> deprecatedBatchGetCounts(BatchGetInventoryCountsRequest request) {
        return this.deprecatedBatchGetCounts(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SquareClientHttpResponse<BatchGetInventoryCountsResponse> deprecatedBatchGetCounts(BatchGetInventoryCountsRequest request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/inventory/batch-retrieve-counts").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new SquareException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                SquareClientHttpResponse<BatchGetInventoryCountsResponse> squareClientHttpResponse = new SquareClientHttpResponse<BatchGetInventoryCountsResponse>((BatchGetInventoryCountsResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), BatchGetInventoryCountsResponse.class), response);
                return squareClientHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            throw new SquareApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new SquareException("Network error executing HTTP request", e);
        }
    }

    public SquareClientHttpResponse<BatchChangeInventoryResponse> batchCreateChanges(BatchChangeInventoryRequest request) {
        return this.batchCreateChanges(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SquareClientHttpResponse<BatchChangeInventoryResponse> batchCreateChanges(BatchChangeInventoryRequest request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/inventory/changes/batch-create").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new SquareException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                SquareClientHttpResponse<BatchChangeInventoryResponse> squareClientHttpResponse = new SquareClientHttpResponse<BatchChangeInventoryResponse>((BatchChangeInventoryResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), BatchChangeInventoryResponse.class), response);
                return squareClientHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            throw new SquareApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new SquareException("Network error executing HTTP request", e);
        }
    }

    public SquareClientHttpResponse<SyncPagingIterable<InventoryChange>> batchGetChanges() {
        return this.batchGetChanges(BatchRetrieveInventoryChangesRequest.builder().build());
    }

    public SquareClientHttpResponse<SyncPagingIterable<InventoryChange>> batchGetChanges(BatchRetrieveInventoryChangesRequest request) {
        return this.batchGetChanges(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SquareClientHttpResponse<SyncPagingIterable<InventoryChange>> batchGetChanges(BatchRetrieveInventoryChangesRequest request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/inventory/changes/batch-retrieve").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new SquareException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                BatchGetInventoryChangesResponse parsedResponse = (BatchGetInventoryChangesResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), BatchGetInventoryChangesResponse.class);
                Optional<String> startingAfter = parsedResponse.getCursor();
                BatchRetrieveInventoryChangesRequest nextRequest = BatchRetrieveInventoryChangesRequest.builder().from(request).cursor(startingAfter).build();
                List result = parsedResponse.getChanges().orElse(Collections.emptyList());
                SquareClientHttpResponse<SyncPagingIterable<InventoryChange>> squareClientHttpResponse = new SquareClientHttpResponse<SyncPagingIterable<InventoryChange>>(new SyncPagingIterable(startingAfter.isPresent(), result, () -> this.batchGetChanges(nextRequest, requestOptions).body()), response);
                return squareClientHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            throw new SquareApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new SquareException("Network error executing HTTP request", e);
        }
    }

    public SquareClientHttpResponse<SyncPagingIterable<InventoryCount>> batchGetCounts() {
        return this.batchGetCounts(BatchGetInventoryCountsRequest.builder().build());
    }

    public SquareClientHttpResponse<SyncPagingIterable<InventoryCount>> batchGetCounts(BatchGetInventoryCountsRequest request) {
        return this.batchGetCounts(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SquareClientHttpResponse<SyncPagingIterable<InventoryCount>> batchGetCounts(BatchGetInventoryCountsRequest request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/inventory/counts/batch-retrieve").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new SquareException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                BatchGetInventoryCountsResponse parsedResponse = (BatchGetInventoryCountsResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), BatchGetInventoryCountsResponse.class);
                Optional<String> startingAfter = parsedResponse.getCursor();
                BatchGetInventoryCountsRequest nextRequest = BatchGetInventoryCountsRequest.builder().from(request).cursor(startingAfter).build();
                List result = parsedResponse.getCounts().orElse(Collections.emptyList());
                SquareClientHttpResponse<SyncPagingIterable<InventoryCount>> squareClientHttpResponse = new SquareClientHttpResponse<SyncPagingIterable<InventoryCount>>(new SyncPagingIterable(startingAfter.isPresent(), result, () -> this.batchGetCounts(nextRequest, requestOptions).body()), response);
                return squareClientHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            throw new SquareApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new SquareException("Network error executing HTTP request", e);
        }
    }

    public SquareClientHttpResponse<GetInventoryPhysicalCountResponse> deprecatedGetPhysicalCount(DeprecatedGetPhysicalCountInventoryRequest request) {
        return this.deprecatedGetPhysicalCount(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SquareClientHttpResponse<GetInventoryPhysicalCountResponse> deprecatedGetPhysicalCount(DeprecatedGetPhysicalCountInventoryRequest request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/inventory/physical-count").addPathSegment(request.getPhysicalCountId()).build();
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                SquareClientHttpResponse<GetInventoryPhysicalCountResponse> squareClientHttpResponse = new SquareClientHttpResponse<GetInventoryPhysicalCountResponse>((GetInventoryPhysicalCountResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), GetInventoryPhysicalCountResponse.class), response);
                return squareClientHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            throw new SquareApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new SquareException("Network error executing HTTP request", e);
        }
    }

    public SquareClientHttpResponse<GetInventoryPhysicalCountResponse> getPhysicalCount(GetPhysicalCountInventoryRequest request) {
        return this.getPhysicalCount(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SquareClientHttpResponse<GetInventoryPhysicalCountResponse> getPhysicalCount(GetPhysicalCountInventoryRequest request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/inventory/physical-counts").addPathSegment(request.getPhysicalCountId()).build();
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                SquareClientHttpResponse<GetInventoryPhysicalCountResponse> squareClientHttpResponse = new SquareClientHttpResponse<GetInventoryPhysicalCountResponse>((GetInventoryPhysicalCountResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), GetInventoryPhysicalCountResponse.class), response);
                return squareClientHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            throw new SquareApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new SquareException("Network error executing HTTP request", e);
        }
    }

    public SquareClientHttpResponse<GetInventoryTransferResponse> getTransfer(GetTransferInventoryRequest request) {
        return this.getTransfer(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SquareClientHttpResponse<GetInventoryTransferResponse> getTransfer(GetTransferInventoryRequest request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/inventory/transfers").addPathSegment(request.getTransferId()).build();
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                SquareClientHttpResponse<GetInventoryTransferResponse> squareClientHttpResponse = new SquareClientHttpResponse<GetInventoryTransferResponse>((GetInventoryTransferResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), GetInventoryTransferResponse.class), response);
                return squareClientHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            throw new SquareApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new SquareException("Network error executing HTTP request", e);
        }
    }

    public SquareClientHttpResponse<SyncPagingIterable<InventoryCount>> get(GetInventoryRequest request) {
        return this.get(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SquareClientHttpResponse<SyncPagingIterable<InventoryCount>> get(GetInventoryRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/inventory").addPathSegment(request.getCatalogObjectId());
        if (request.getLocationIds().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "location_ids", request.getLocationIds().get(), false);
        }
        if (request.getCursor().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "cursor", request.getCursor().get(), false);
        }
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                GetInventoryCountResponse parsedResponse = (GetInventoryCountResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), GetInventoryCountResponse.class);
                Optional<String> startingAfter = parsedResponse.getCursor();
                GetInventoryRequest nextRequest = GetInventoryRequest.builder().from(request).cursor(startingAfter).build();
                List result = parsedResponse.getCounts().orElse(Collections.emptyList());
                SquareClientHttpResponse<SyncPagingIterable<InventoryCount>> squareClientHttpResponse = new SquareClientHttpResponse<SyncPagingIterable<InventoryCount>>(new SyncPagingIterable(startingAfter.isPresent(), result, () -> this.get(nextRequest, requestOptions).body()), response);
                return squareClientHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            throw new SquareApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new SquareException("Network error executing HTTP request", e);
        }
    }

    public SquareClientHttpResponse<SyncPagingIterable<InventoryChange>> changes(ChangesInventoryRequest request) {
        return this.changes(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SquareClientHttpResponse<SyncPagingIterable<InventoryChange>> changes(ChangesInventoryRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/inventory").addPathSegment(request.getCatalogObjectId()).addPathSegments("changes");
        if (request.getLocationIds().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "location_ids", request.getLocationIds().get(), false);
        }
        if (request.getCursor().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "cursor", request.getCursor().get(), false);
        }
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                GetInventoryChangesResponse parsedResponse = (GetInventoryChangesResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), GetInventoryChangesResponse.class);
                Optional<String> startingAfter = parsedResponse.getCursor();
                ChangesInventoryRequest nextRequest = ChangesInventoryRequest.builder().from(request).cursor(startingAfter).build();
                List result = parsedResponse.getChanges().orElse(Collections.emptyList());
                SquareClientHttpResponse<SyncPagingIterable<InventoryChange>> squareClientHttpResponse = new SquareClientHttpResponse<SyncPagingIterable<InventoryChange>>(new SyncPagingIterable(startingAfter.isPresent(), result, () -> this.changes(nextRequest, requestOptions).body()), response);
                return squareClientHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            throw new SquareApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new SquareException("Network error executing HTTP request", e);
        }
    }
}

