/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square;

import com.squareup.square.RawPaymentsClient;
import com.squareup.square.core.ClientOptions;
import com.squareup.square.core.RequestOptions;
import com.squareup.square.core.SyncPagingIterable;
import com.squareup.square.types.CancelPaymentByIdempotencyKeyRequest;
import com.squareup.square.types.CancelPaymentByIdempotencyKeyResponse;
import com.squareup.square.types.CancelPaymentResponse;
import com.squareup.square.types.CancelPaymentsRequest;
import com.squareup.square.types.CompletePaymentRequest;
import com.squareup.square.types.CompletePaymentResponse;
import com.squareup.square.types.CreatePaymentRequest;
import com.squareup.square.types.CreatePaymentResponse;
import com.squareup.square.types.GetPaymentResponse;
import com.squareup.square.types.GetPaymentsRequest;
import com.squareup.square.types.ListPaymentsRequest;
import com.squareup.square.types.Payment;
import com.squareup.square.types.UpdatePaymentRequest;
import com.squareup.square.types.UpdatePaymentResponse;

public class PaymentsClient {
    protected final ClientOptions clientOptions;
    private final RawPaymentsClient rawClient;

    public PaymentsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawPaymentsClient(clientOptions);
    }

    public RawPaymentsClient withRawResponse() {
        return this.rawClient;
    }

    public SyncPagingIterable<Payment> list() {
        return this.rawClient.list().body();
    }

    public SyncPagingIterable<Payment> list(ListPaymentsRequest request) {
        return this.rawClient.list(request).body();
    }

    public SyncPagingIterable<Payment> list(ListPaymentsRequest request, RequestOptions requestOptions) {
        return this.rawClient.list(request, requestOptions).body();
    }

    public CreatePaymentResponse create(CreatePaymentRequest request) {
        return this.rawClient.create(request).body();
    }

    public CreatePaymentResponse create(CreatePaymentRequest request, RequestOptions requestOptions) {
        return this.rawClient.create(request, requestOptions).body();
    }

    public CancelPaymentByIdempotencyKeyResponse cancelByIdempotencyKey(CancelPaymentByIdempotencyKeyRequest request) {
        return this.rawClient.cancelByIdempotencyKey(request).body();
    }

    public CancelPaymentByIdempotencyKeyResponse cancelByIdempotencyKey(CancelPaymentByIdempotencyKeyRequest request, RequestOptions requestOptions) {
        return this.rawClient.cancelByIdempotencyKey(request, requestOptions).body();
    }

    public GetPaymentResponse get(GetPaymentsRequest request) {
        return this.rawClient.get(request).body();
    }

    public GetPaymentResponse get(GetPaymentsRequest request, RequestOptions requestOptions) {
        return this.rawClient.get(request, requestOptions).body();
    }

    public UpdatePaymentResponse update(UpdatePaymentRequest request) {
        return this.rawClient.update(request).body();
    }

    public UpdatePaymentResponse update(UpdatePaymentRequest request, RequestOptions requestOptions) {
        return this.rawClient.update(request, requestOptions).body();
    }

    public CancelPaymentResponse cancel(CancelPaymentsRequest request) {
        return this.rawClient.cancel(request).body();
    }

    public CancelPaymentResponse cancel(CancelPaymentsRequest request, RequestOptions requestOptions) {
        return this.rawClient.cancel(request, requestOptions).body();
    }

    public CompletePaymentResponse complete(CompletePaymentRequest request) {
        return this.rawClient.complete(request).body();
    }

    public CompletePaymentResponse complete(CompletePaymentRequest request, RequestOptions requestOptions) {
        return this.rawClient.complete(request, requestOptions).body();
    }
}

