/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square;

import com.squareup.square.RawOrdersClient;
import com.squareup.square.core.ClientOptions;
import com.squareup.square.core.RequestOptions;
import com.squareup.square.core.Suppliers;
import com.squareup.square.orders.CustomAttributeDefinitionsClient;
import com.squareup.square.orders.CustomAttributesClient;
import com.squareup.square.types.BatchGetOrdersRequest;
import com.squareup.square.types.BatchGetOrdersResponse;
import com.squareup.square.types.CalculateOrderRequest;
import com.squareup.square.types.CalculateOrderResponse;
import com.squareup.square.types.CloneOrderRequest;
import com.squareup.square.types.CloneOrderResponse;
import com.squareup.square.types.CreateOrderRequest;
import com.squareup.square.types.CreateOrderResponse;
import com.squareup.square.types.GetOrderResponse;
import com.squareup.square.types.GetOrdersRequest;
import com.squareup.square.types.PayOrderRequest;
import com.squareup.square.types.PayOrderResponse;
import com.squareup.square.types.SearchOrdersRequest;
import com.squareup.square.types.SearchOrdersResponse;
import com.squareup.square.types.UpdateOrderRequest;
import com.squareup.square.types.UpdateOrderResponse;
import java.util.function.Supplier;

public class OrdersClient {
    protected final ClientOptions clientOptions;
    private final RawOrdersClient rawClient;
    protected final Supplier<CustomAttributeDefinitionsClient> customAttributeDefinitionsClient;
    protected final Supplier<CustomAttributesClient> customAttributesClient;

    public OrdersClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawOrdersClient(clientOptions);
        this.customAttributeDefinitionsClient = Suppliers.memoize(() -> new CustomAttributeDefinitionsClient(clientOptions));
        this.customAttributesClient = Suppliers.memoize(() -> new CustomAttributesClient(clientOptions));
    }

    public RawOrdersClient withRawResponse() {
        return this.rawClient;
    }

    public CreateOrderResponse create() {
        return this.rawClient.create().body();
    }

    public CreateOrderResponse create(CreateOrderRequest request) {
        return this.rawClient.create(request).body();
    }

    public CreateOrderResponse create(CreateOrderRequest request, RequestOptions requestOptions) {
        return this.rawClient.create(request, requestOptions).body();
    }

    public BatchGetOrdersResponse batchGet(BatchGetOrdersRequest request) {
        return this.rawClient.batchGet(request).body();
    }

    public BatchGetOrdersResponse batchGet(BatchGetOrdersRequest request, RequestOptions requestOptions) {
        return this.rawClient.batchGet(request, requestOptions).body();
    }

    public CalculateOrderResponse calculate(CalculateOrderRequest request) {
        return this.rawClient.calculate(request).body();
    }

    public CalculateOrderResponse calculate(CalculateOrderRequest request, RequestOptions requestOptions) {
        return this.rawClient.calculate(request, requestOptions).body();
    }

    public CloneOrderResponse clone(CloneOrderRequest request) {
        return this.rawClient.clone(request).body();
    }

    public CloneOrderResponse clone(CloneOrderRequest request, RequestOptions requestOptions) {
        return this.rawClient.clone(request, requestOptions).body();
    }

    public SearchOrdersResponse search() {
        return this.rawClient.search().body();
    }

    public SearchOrdersResponse search(SearchOrdersRequest request) {
        return this.rawClient.search(request).body();
    }

    public SearchOrdersResponse search(SearchOrdersRequest request, RequestOptions requestOptions) {
        return this.rawClient.search(request, requestOptions).body();
    }

    public GetOrderResponse get(GetOrdersRequest request) {
        return this.rawClient.get(request).body();
    }

    public GetOrderResponse get(GetOrdersRequest request, RequestOptions requestOptions) {
        return this.rawClient.get(request, requestOptions).body();
    }

    public UpdateOrderResponse update(UpdateOrderRequest request) {
        return this.rawClient.update(request).body();
    }

    public UpdateOrderResponse update(UpdateOrderRequest request, RequestOptions requestOptions) {
        return this.rawClient.update(request, requestOptions).body();
    }

    public PayOrderResponse pay(PayOrderRequest request) {
        return this.rawClient.pay(request).body();
    }

    public PayOrderResponse pay(PayOrderRequest request, RequestOptions requestOptions) {
        return this.rawClient.pay(request, requestOptions).body();
    }

    public CustomAttributeDefinitionsClient customAttributeDefinitions() {
        return this.customAttributeDefinitionsClient.get();
    }

    public CustomAttributesClient customAttributes() {
        return this.customAttributesClient.get();
    }
}

