/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square;

import com.squareup.square.RawMerchantsClient;
import com.squareup.square.core.ClientOptions;
import com.squareup.square.core.RequestOptions;
import com.squareup.square.core.Suppliers;
import com.squareup.square.core.SyncPagingIterable;
import com.squareup.square.merchants.CustomAttributeDefinitionsClient;
import com.squareup.square.merchants.CustomAttributesClient;
import com.squareup.square.types.GetMerchantResponse;
import com.squareup.square.types.GetMerchantsRequest;
import com.squareup.square.types.ListMerchantsRequest;
import com.squareup.square.types.Merchant;
import java.util.function.Supplier;

public class MerchantsClient {
    protected final ClientOptions clientOptions;
    private final RawMerchantsClient rawClient;
    protected final Supplier<CustomAttributeDefinitionsClient> customAttributeDefinitionsClient;
    protected final Supplier<CustomAttributesClient> customAttributesClient;

    public MerchantsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawMerchantsClient(clientOptions);
        this.customAttributeDefinitionsClient = Suppliers.memoize(() -> new CustomAttributeDefinitionsClient(clientOptions));
        this.customAttributesClient = Suppliers.memoize(() -> new CustomAttributesClient(clientOptions));
    }

    public RawMerchantsClient withRawResponse() {
        return this.rawClient;
    }

    public SyncPagingIterable<Merchant> list() {
        return this.rawClient.list().body();
    }

    public SyncPagingIterable<Merchant> list(ListMerchantsRequest request) {
        return this.rawClient.list(request).body();
    }

    public SyncPagingIterable<Merchant> list(ListMerchantsRequest request, RequestOptions requestOptions) {
        return this.rawClient.list(request, requestOptions).body();
    }

    public GetMerchantResponse get(GetMerchantsRequest request) {
        return this.rawClient.get(request).body();
    }

    public GetMerchantResponse get(GetMerchantsRequest request, RequestOptions requestOptions) {
        return this.rawClient.get(request, requestOptions).body();
    }

    public CustomAttributeDefinitionsClient customAttributeDefinitions() {
        return this.customAttributeDefinitionsClient.get();
    }

    public CustomAttributesClient customAttributes() {
        return this.customAttributesClient.get();
    }
}

