/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square;

import com.squareup.square.RawEventsClient;
import com.squareup.square.core.ClientOptions;
import com.squareup.square.core.RequestOptions;
import com.squareup.square.types.DisableEventsResponse;
import com.squareup.square.types.EnableEventsResponse;
import com.squareup.square.types.ListEventTypesRequest;
import com.squareup.square.types.ListEventTypesResponse;
import com.squareup.square.types.SearchEventsRequest;
import com.squareup.square.types.SearchEventsResponse;

public class EventsClient {
    protected final ClientOptions clientOptions;
    private final RawEventsClient rawClient;

    public EventsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawEventsClient(clientOptions);
    }

    public RawEventsClient withRawResponse() {
        return this.rawClient;
    }

    public SearchEventsResponse searchEvents() {
        return this.rawClient.searchEvents().body();
    }

    public SearchEventsResponse searchEvents(SearchEventsRequest request) {
        return this.rawClient.searchEvents(request).body();
    }

    public SearchEventsResponse searchEvents(SearchEventsRequest request, RequestOptions requestOptions) {
        return this.rawClient.searchEvents(request, requestOptions).body();
    }

    public DisableEventsResponse disableEvents() {
        return this.rawClient.disableEvents().body();
    }

    public DisableEventsResponse disableEvents(RequestOptions requestOptions) {
        return this.rawClient.disableEvents(requestOptions).body();
    }

    public EnableEventsResponse enableEvents() {
        return this.rawClient.enableEvents().body();
    }

    public EnableEventsResponse enableEvents(RequestOptions requestOptions) {
        return this.rawClient.enableEvents(requestOptions).body();
    }

    public ListEventTypesResponse listEventTypes() {
        return this.rawClient.listEventTypes().body();
    }

    public ListEventTypesResponse listEventTypes(ListEventTypesRequest request) {
        return this.rawClient.listEventTypes(request).body();
    }

    public ListEventTypesResponse listEventTypes(ListEventTypesRequest request, RequestOptions requestOptions) {
        return this.rawClient.listEventTypes(request, requestOptions).body();
    }
}

