/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square;

import com.squareup.square.RawDevicesClient;
import com.squareup.square.core.ClientOptions;
import com.squareup.square.core.RequestOptions;
import com.squareup.square.core.Suppliers;
import com.squareup.square.core.SyncPagingIterable;
import com.squareup.square.devices.CodesClient;
import com.squareup.square.types.Device;
import com.squareup.square.types.GetDeviceResponse;
import com.squareup.square.types.GetDevicesRequest;
import com.squareup.square.types.ListDevicesRequest;
import java.util.function.Supplier;

public class DevicesClient {
    protected final ClientOptions clientOptions;
    private final RawDevicesClient rawClient;
    protected final Supplier<CodesClient> codesClient;

    public DevicesClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawDevicesClient(clientOptions);
        this.codesClient = Suppliers.memoize(() -> new CodesClient(clientOptions));
    }

    public RawDevicesClient withRawResponse() {
        return this.rawClient;
    }

    public SyncPagingIterable<Device> list() {
        return this.rawClient.list().body();
    }

    public SyncPagingIterable<Device> list(ListDevicesRequest request) {
        return this.rawClient.list(request).body();
    }

    public SyncPagingIterable<Device> list(ListDevicesRequest request, RequestOptions requestOptions) {
        return this.rawClient.list(request, requestOptions).body();
    }

    public GetDeviceResponse get(GetDevicesRequest request) {
        return this.rawClient.get(request).body();
    }

    public GetDeviceResponse get(GetDevicesRequest request, RequestOptions requestOptions) {
        return this.rawClient.get(request, requestOptions).body();
    }

    public CodesClient codes() {
        return this.codesClient.get();
    }
}

