/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square;

import com.squareup.square.RawCustomersClient;
import com.squareup.square.core.ClientOptions;
import com.squareup.square.core.RequestOptions;
import com.squareup.square.core.Suppliers;
import com.squareup.square.core.SyncPagingIterable;
import com.squareup.square.customers.CardsClient;
import com.squareup.square.customers.CustomAttributeDefinitionsClient;
import com.squareup.square.customers.CustomAttributesClient;
import com.squareup.square.customers.GroupsClient;
import com.squareup.square.customers.SegmentsClient;
import com.squareup.square.types.BulkCreateCustomersRequest;
import com.squareup.square.types.BulkCreateCustomersResponse;
import com.squareup.square.types.BulkDeleteCustomersRequest;
import com.squareup.square.types.BulkDeleteCustomersResponse;
import com.squareup.square.types.BulkRetrieveCustomersRequest;
import com.squareup.square.types.BulkRetrieveCustomersResponse;
import com.squareup.square.types.BulkUpdateCustomersRequest;
import com.squareup.square.types.BulkUpdateCustomersResponse;
import com.squareup.square.types.CreateCustomerRequest;
import com.squareup.square.types.CreateCustomerResponse;
import com.squareup.square.types.Customer;
import com.squareup.square.types.DeleteCustomerResponse;
import com.squareup.square.types.DeleteCustomersRequest;
import com.squareup.square.types.GetCustomerResponse;
import com.squareup.square.types.GetCustomersRequest;
import com.squareup.square.types.ListCustomersRequest;
import com.squareup.square.types.SearchCustomersRequest;
import com.squareup.square.types.SearchCustomersResponse;
import com.squareup.square.types.UpdateCustomerRequest;
import com.squareup.square.types.UpdateCustomerResponse;
import java.util.function.Supplier;

public class CustomersClient {
    protected final ClientOptions clientOptions;
    private final RawCustomersClient rawClient;
    protected final Supplier<CustomAttributeDefinitionsClient> customAttributeDefinitionsClient;
    protected final Supplier<GroupsClient> groupsClient;
    protected final Supplier<SegmentsClient> segmentsClient;
    protected final Supplier<CardsClient> cardsClient;
    protected final Supplier<CustomAttributesClient> customAttributesClient;

    public CustomersClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawCustomersClient(clientOptions);
        this.customAttributeDefinitionsClient = Suppliers.memoize(() -> new CustomAttributeDefinitionsClient(clientOptions));
        this.groupsClient = Suppliers.memoize(() -> new GroupsClient(clientOptions));
        this.segmentsClient = Suppliers.memoize(() -> new SegmentsClient(clientOptions));
        this.cardsClient = Suppliers.memoize(() -> new CardsClient(clientOptions));
        this.customAttributesClient = Suppliers.memoize(() -> new CustomAttributesClient(clientOptions));
    }

    public RawCustomersClient withRawResponse() {
        return this.rawClient;
    }

    public SyncPagingIterable<Customer> list() {
        return this.rawClient.list().body();
    }

    public SyncPagingIterable<Customer> list(ListCustomersRequest request) {
        return this.rawClient.list(request).body();
    }

    public SyncPagingIterable<Customer> list(ListCustomersRequest request, RequestOptions requestOptions) {
        return this.rawClient.list(request, requestOptions).body();
    }

    public CreateCustomerResponse create() {
        return this.rawClient.create().body();
    }

    public CreateCustomerResponse create(CreateCustomerRequest request) {
        return this.rawClient.create(request).body();
    }

    public CreateCustomerResponse create(CreateCustomerRequest request, RequestOptions requestOptions) {
        return this.rawClient.create(request, requestOptions).body();
    }

    public BulkCreateCustomersResponse batchCreate(BulkCreateCustomersRequest request) {
        return this.rawClient.batchCreate(request).body();
    }

    public BulkCreateCustomersResponse batchCreate(BulkCreateCustomersRequest request, RequestOptions requestOptions) {
        return this.rawClient.batchCreate(request, requestOptions).body();
    }

    public BulkDeleteCustomersResponse bulkDeleteCustomers(BulkDeleteCustomersRequest request) {
        return this.rawClient.bulkDeleteCustomers(request).body();
    }

    public BulkDeleteCustomersResponse bulkDeleteCustomers(BulkDeleteCustomersRequest request, RequestOptions requestOptions) {
        return this.rawClient.bulkDeleteCustomers(request, requestOptions).body();
    }

    public BulkRetrieveCustomersResponse bulkRetrieveCustomers(BulkRetrieveCustomersRequest request) {
        return this.rawClient.bulkRetrieveCustomers(request).body();
    }

    public BulkRetrieveCustomersResponse bulkRetrieveCustomers(BulkRetrieveCustomersRequest request, RequestOptions requestOptions) {
        return this.rawClient.bulkRetrieveCustomers(request, requestOptions).body();
    }

    public BulkUpdateCustomersResponse bulkUpdateCustomers(BulkUpdateCustomersRequest request) {
        return this.rawClient.bulkUpdateCustomers(request).body();
    }

    public BulkUpdateCustomersResponse bulkUpdateCustomers(BulkUpdateCustomersRequest request, RequestOptions requestOptions) {
        return this.rawClient.bulkUpdateCustomers(request, requestOptions).body();
    }

    public SearchCustomersResponse search() {
        return this.rawClient.search().body();
    }

    public SearchCustomersResponse search(SearchCustomersRequest request) {
        return this.rawClient.search(request).body();
    }

    public SearchCustomersResponse search(SearchCustomersRequest request, RequestOptions requestOptions) {
        return this.rawClient.search(request, requestOptions).body();
    }

    public GetCustomerResponse get(GetCustomersRequest request) {
        return this.rawClient.get(request).body();
    }

    public GetCustomerResponse get(GetCustomersRequest request, RequestOptions requestOptions) {
        return this.rawClient.get(request, requestOptions).body();
    }

    public UpdateCustomerResponse update(UpdateCustomerRequest request) {
        return this.rawClient.update(request).body();
    }

    public UpdateCustomerResponse update(UpdateCustomerRequest request, RequestOptions requestOptions) {
        return this.rawClient.update(request, requestOptions).body();
    }

    public DeleteCustomerResponse delete(DeleteCustomersRequest request) {
        return this.rawClient.delete(request).body();
    }

    public DeleteCustomerResponse delete(DeleteCustomersRequest request, RequestOptions requestOptions) {
        return this.rawClient.delete(request, requestOptions).body();
    }

    public CustomAttributeDefinitionsClient customAttributeDefinitions() {
        return this.customAttributeDefinitionsClient.get();
    }

    public GroupsClient groups() {
        return this.groupsClient.get();
    }

    public SegmentsClient segments() {
        return this.segmentsClient.get();
    }

    public CardsClient cards() {
        return this.cardsClient.get();
    }

    public CustomAttributesClient customAttributes() {
        return this.customAttributesClient.get();
    }
}

