/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square;

import com.squareup.square.RawBookingsClient;
import com.squareup.square.bookings.CustomAttributeDefinitionsClient;
import com.squareup.square.bookings.CustomAttributesClient;
import com.squareup.square.bookings.LocationProfilesClient;
import com.squareup.square.bookings.TeamMemberProfilesClient;
import com.squareup.square.core.ClientOptions;
import com.squareup.square.core.RequestOptions;
import com.squareup.square.core.Suppliers;
import com.squareup.square.core.SyncPagingIterable;
import com.squareup.square.types.Booking;
import com.squareup.square.types.BulkRetrieveBookingsRequest;
import com.squareup.square.types.BulkRetrieveBookingsResponse;
import com.squareup.square.types.BulkRetrieveTeamMemberBookingProfilesRequest;
import com.squareup.square.types.BulkRetrieveTeamMemberBookingProfilesResponse;
import com.squareup.square.types.CancelBookingRequest;
import com.squareup.square.types.CancelBookingResponse;
import com.squareup.square.types.CreateBookingRequest;
import com.squareup.square.types.CreateBookingResponse;
import com.squareup.square.types.GetBookingResponse;
import com.squareup.square.types.GetBookingsRequest;
import com.squareup.square.types.GetBusinessBookingProfileResponse;
import com.squareup.square.types.ListBookingsRequest;
import com.squareup.square.types.RetrieveLocationBookingProfileRequest;
import com.squareup.square.types.RetrieveLocationBookingProfileResponse;
import com.squareup.square.types.SearchAvailabilityRequest;
import com.squareup.square.types.SearchAvailabilityResponse;
import com.squareup.square.types.UpdateBookingRequest;
import com.squareup.square.types.UpdateBookingResponse;
import java.util.function.Supplier;

public class BookingsClient {
    protected final ClientOptions clientOptions;
    private final RawBookingsClient rawClient;
    protected final Supplier<CustomAttributeDefinitionsClient> customAttributeDefinitionsClient;
    protected final Supplier<CustomAttributesClient> customAttributesClient;
    protected final Supplier<LocationProfilesClient> locationProfilesClient;
    protected final Supplier<TeamMemberProfilesClient> teamMemberProfilesClient;

    public BookingsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawBookingsClient(clientOptions);
        this.customAttributeDefinitionsClient = Suppliers.memoize(() -> new CustomAttributeDefinitionsClient(clientOptions));
        this.customAttributesClient = Suppliers.memoize(() -> new CustomAttributesClient(clientOptions));
        this.locationProfilesClient = Suppliers.memoize(() -> new LocationProfilesClient(clientOptions));
        this.teamMemberProfilesClient = Suppliers.memoize(() -> new TeamMemberProfilesClient(clientOptions));
    }

    public RawBookingsClient withRawResponse() {
        return this.rawClient;
    }

    public SyncPagingIterable<Booking> list() {
        return this.rawClient.list().body();
    }

    public SyncPagingIterable<Booking> list(ListBookingsRequest request) {
        return this.rawClient.list(request).body();
    }

    public SyncPagingIterable<Booking> list(ListBookingsRequest request, RequestOptions requestOptions) {
        return this.rawClient.list(request, requestOptions).body();
    }

    public CreateBookingResponse create(CreateBookingRequest request) {
        return this.rawClient.create(request).body();
    }

    public CreateBookingResponse create(CreateBookingRequest request, RequestOptions requestOptions) {
        return this.rawClient.create(request, requestOptions).body();
    }

    public SearchAvailabilityResponse searchAvailability(SearchAvailabilityRequest request) {
        return this.rawClient.searchAvailability(request).body();
    }

    public SearchAvailabilityResponse searchAvailability(SearchAvailabilityRequest request, RequestOptions requestOptions) {
        return this.rawClient.searchAvailability(request, requestOptions).body();
    }

    public BulkRetrieveBookingsResponse bulkRetrieveBookings(BulkRetrieveBookingsRequest request) {
        return this.rawClient.bulkRetrieveBookings(request).body();
    }

    public BulkRetrieveBookingsResponse bulkRetrieveBookings(BulkRetrieveBookingsRequest request, RequestOptions requestOptions) {
        return this.rawClient.bulkRetrieveBookings(request, requestOptions).body();
    }

    public GetBusinessBookingProfileResponse getBusinessProfile() {
        return this.rawClient.getBusinessProfile().body();
    }

    public GetBusinessBookingProfileResponse getBusinessProfile(RequestOptions requestOptions) {
        return this.rawClient.getBusinessProfile(requestOptions).body();
    }

    public RetrieveLocationBookingProfileResponse retrieveLocationBookingProfile(RetrieveLocationBookingProfileRequest request) {
        return this.rawClient.retrieveLocationBookingProfile(request).body();
    }

    public RetrieveLocationBookingProfileResponse retrieveLocationBookingProfile(RetrieveLocationBookingProfileRequest request, RequestOptions requestOptions) {
        return this.rawClient.retrieveLocationBookingProfile(request, requestOptions).body();
    }

    public BulkRetrieveTeamMemberBookingProfilesResponse bulkRetrieveTeamMemberBookingProfiles(BulkRetrieveTeamMemberBookingProfilesRequest request) {
        return this.rawClient.bulkRetrieveTeamMemberBookingProfiles(request).body();
    }

    public BulkRetrieveTeamMemberBookingProfilesResponse bulkRetrieveTeamMemberBookingProfiles(BulkRetrieveTeamMemberBookingProfilesRequest request, RequestOptions requestOptions) {
        return this.rawClient.bulkRetrieveTeamMemberBookingProfiles(request, requestOptions).body();
    }

    public GetBookingResponse get(GetBookingsRequest request) {
        return this.rawClient.get(request).body();
    }

    public GetBookingResponse get(GetBookingsRequest request, RequestOptions requestOptions) {
        return this.rawClient.get(request, requestOptions).body();
    }

    public UpdateBookingResponse update(UpdateBookingRequest request) {
        return this.rawClient.update(request).body();
    }

    public UpdateBookingResponse update(UpdateBookingRequest request, RequestOptions requestOptions) {
        return this.rawClient.update(request, requestOptions).body();
    }

    public CancelBookingResponse cancel(CancelBookingRequest request) {
        return this.rawClient.cancel(request).body();
    }

    public CancelBookingResponse cancel(CancelBookingRequest request, RequestOptions requestOptions) {
        return this.rawClient.cancel(request, requestOptions).body();
    }

    public CustomAttributeDefinitionsClient customAttributeDefinitions() {
        return this.customAttributeDefinitionsClient.get();
    }

    public CustomAttributesClient customAttributes() {
        return this.customAttributesClient.get();
    }

    public LocationProfilesClient locationProfiles() {
        return this.locationProfilesClient.get();
    }

    public TeamMemberProfilesClient teamMemberProfiles() {
        return this.teamMemberProfilesClient.get();
    }
}

