/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square;

import com.squareup.square.AsyncRawTeamMembersClient;
import com.squareup.square.core.ClientOptions;
import com.squareup.square.core.RequestOptions;
import com.squareup.square.core.Suppliers;
import com.squareup.square.teammembers.AsyncWageSettingClient;
import com.squareup.square.types.BatchCreateTeamMembersRequest;
import com.squareup.square.types.BatchCreateTeamMembersResponse;
import com.squareup.square.types.BatchUpdateTeamMembersRequest;
import com.squareup.square.types.BatchUpdateTeamMembersResponse;
import com.squareup.square.types.CreateTeamMemberRequest;
import com.squareup.square.types.CreateTeamMemberResponse;
import com.squareup.square.types.GetTeamMemberResponse;
import com.squareup.square.types.GetTeamMembersRequest;
import com.squareup.square.types.SearchTeamMembersRequest;
import com.squareup.square.types.SearchTeamMembersResponse;
import com.squareup.square.types.UpdateTeamMemberResponse;
import com.squareup.square.types.UpdateTeamMembersRequest;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;

public class AsyncTeamMembersClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawTeamMembersClient rawClient;
    protected final Supplier<AsyncWageSettingClient> wageSettingClient;

    public AsyncTeamMembersClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawTeamMembersClient(clientOptions);
        this.wageSettingClient = Suppliers.memoize(() -> new AsyncWageSettingClient(clientOptions));
    }

    public AsyncRawTeamMembersClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<CreateTeamMemberResponse> create() {
        return this.rawClient.create().thenApply(response -> (CreateTeamMemberResponse)response.body());
    }

    public CompletableFuture<CreateTeamMemberResponse> create(CreateTeamMemberRequest request) {
        return this.rawClient.create(request).thenApply(response -> (CreateTeamMemberResponse)response.body());
    }

    public CompletableFuture<CreateTeamMemberResponse> create(CreateTeamMemberRequest request, RequestOptions requestOptions) {
        return this.rawClient.create(request, requestOptions).thenApply(response -> (CreateTeamMemberResponse)response.body());
    }

    public CompletableFuture<BatchCreateTeamMembersResponse> batchCreate(BatchCreateTeamMembersRequest request) {
        return this.rawClient.batchCreate(request).thenApply(response -> (BatchCreateTeamMembersResponse)response.body());
    }

    public CompletableFuture<BatchCreateTeamMembersResponse> batchCreate(BatchCreateTeamMembersRequest request, RequestOptions requestOptions) {
        return this.rawClient.batchCreate(request, requestOptions).thenApply(response -> (BatchCreateTeamMembersResponse)response.body());
    }

    public CompletableFuture<BatchUpdateTeamMembersResponse> batchUpdate(BatchUpdateTeamMembersRequest request) {
        return this.rawClient.batchUpdate(request).thenApply(response -> (BatchUpdateTeamMembersResponse)response.body());
    }

    public CompletableFuture<BatchUpdateTeamMembersResponse> batchUpdate(BatchUpdateTeamMembersRequest request, RequestOptions requestOptions) {
        return this.rawClient.batchUpdate(request, requestOptions).thenApply(response -> (BatchUpdateTeamMembersResponse)response.body());
    }

    public CompletableFuture<SearchTeamMembersResponse> search() {
        return this.rawClient.search().thenApply(response -> (SearchTeamMembersResponse)response.body());
    }

    public CompletableFuture<SearchTeamMembersResponse> search(SearchTeamMembersRequest request) {
        return this.rawClient.search(request).thenApply(response -> (SearchTeamMembersResponse)response.body());
    }

    public CompletableFuture<SearchTeamMembersResponse> search(SearchTeamMembersRequest request, RequestOptions requestOptions) {
        return this.rawClient.search(request, requestOptions).thenApply(response -> (SearchTeamMembersResponse)response.body());
    }

    public CompletableFuture<GetTeamMemberResponse> get(GetTeamMembersRequest request) {
        return this.rawClient.get(request).thenApply(response -> (GetTeamMemberResponse)response.body());
    }

    public CompletableFuture<GetTeamMemberResponse> get(GetTeamMembersRequest request, RequestOptions requestOptions) {
        return this.rawClient.get(request, requestOptions).thenApply(response -> (GetTeamMemberResponse)response.body());
    }

    public CompletableFuture<UpdateTeamMemberResponse> update(UpdateTeamMembersRequest request) {
        return this.rawClient.update(request).thenApply(response -> (UpdateTeamMemberResponse)response.body());
    }

    public CompletableFuture<UpdateTeamMemberResponse> update(UpdateTeamMembersRequest request, RequestOptions requestOptions) {
        return this.rawClient.update(request, requestOptions).thenApply(response -> (UpdateTeamMemberResponse)response.body());
    }

    public AsyncWageSettingClient wageSetting() {
        return this.wageSettingClient.get();
    }
}

