/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square;

import com.squareup.square.AsyncRawSnippetsClient;
import com.squareup.square.core.ClientOptions;
import com.squareup.square.core.RequestOptions;
import com.squareup.square.types.DeleteSnippetResponse;
import com.squareup.square.types.DeleteSnippetsRequest;
import com.squareup.square.types.GetSnippetResponse;
import com.squareup.square.types.GetSnippetsRequest;
import com.squareup.square.types.UpsertSnippetRequest;
import com.squareup.square.types.UpsertSnippetResponse;
import java.util.concurrent.CompletableFuture;

public class AsyncSnippetsClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawSnippetsClient rawClient;

    public AsyncSnippetsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawSnippetsClient(clientOptions);
    }

    public AsyncRawSnippetsClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<GetSnippetResponse> get(GetSnippetsRequest request) {
        return this.rawClient.get(request).thenApply(response -> (GetSnippetResponse)response.body());
    }

    public CompletableFuture<GetSnippetResponse> get(GetSnippetsRequest request, RequestOptions requestOptions) {
        return this.rawClient.get(request, requestOptions).thenApply(response -> (GetSnippetResponse)response.body());
    }

    public CompletableFuture<UpsertSnippetResponse> upsert(UpsertSnippetRequest request) {
        return this.rawClient.upsert(request).thenApply(response -> (UpsertSnippetResponse)response.body());
    }

    public CompletableFuture<UpsertSnippetResponse> upsert(UpsertSnippetRequest request, RequestOptions requestOptions) {
        return this.rawClient.upsert(request, requestOptions).thenApply(response -> (UpsertSnippetResponse)response.body());
    }

    public CompletableFuture<DeleteSnippetResponse> delete(DeleteSnippetsRequest request) {
        return this.rawClient.delete(request).thenApply(response -> (DeleteSnippetResponse)response.body());
    }

    public CompletableFuture<DeleteSnippetResponse> delete(DeleteSnippetsRequest request, RequestOptions requestOptions) {
        return this.rawClient.delete(request, requestOptions).thenApply(response -> (DeleteSnippetResponse)response.body());
    }
}

