/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square;

import com.squareup.square.AsyncRawRefundsClient;
import com.squareup.square.core.ClientOptions;
import com.squareup.square.core.RequestOptions;
import com.squareup.square.core.SyncPagingIterable;
import com.squareup.square.types.GetPaymentRefundResponse;
import com.squareup.square.types.GetRefundsRequest;
import com.squareup.square.types.ListRefundsRequest;
import com.squareup.square.types.PaymentRefund;
import com.squareup.square.types.RefundPaymentRequest;
import com.squareup.square.types.RefundPaymentResponse;
import java.util.concurrent.CompletableFuture;

public class AsyncRefundsClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawRefundsClient rawClient;

    public AsyncRefundsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawRefundsClient(clientOptions);
    }

    public AsyncRawRefundsClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<SyncPagingIterable<PaymentRefund>> list() {
        return this.rawClient.list().thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<SyncPagingIterable<PaymentRefund>> list(ListRefundsRequest request) {
        return this.rawClient.list(request).thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<SyncPagingIterable<PaymentRefund>> list(ListRefundsRequest request, RequestOptions requestOptions) {
        return this.rawClient.list(request, requestOptions).thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<RefundPaymentResponse> refundPayment(RefundPaymentRequest request) {
        return this.rawClient.refundPayment(request).thenApply(response -> (RefundPaymentResponse)response.body());
    }

    public CompletableFuture<RefundPaymentResponse> refundPayment(RefundPaymentRequest request, RequestOptions requestOptions) {
        return this.rawClient.refundPayment(request, requestOptions).thenApply(response -> (RefundPaymentResponse)response.body());
    }

    public CompletableFuture<GetPaymentRefundResponse> get(GetRefundsRequest request) {
        return this.rawClient.get(request).thenApply(response -> (GetPaymentRefundResponse)response.body());
    }

    public CompletableFuture<GetPaymentRefundResponse> get(GetRefundsRequest request, RequestOptions requestOptions) {
        return this.rawClient.get(request, requestOptions).thenApply(response -> (GetPaymentRefundResponse)response.body());
    }
}

